% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{GumbelGF}
\alias{GumbelGF}
\title{Gumbel distribution growth factors}
\usage{
GumbelGF(lcv, RP)
}
\arguments{
\item{lcv}{linear coefficient of variation}

\item{RP}{return period}
}
\value{
Gumbel estimated growth factor
}
\description{
Estimated growth factors as a function of return period, with inputs of Lcv & LSkew (linear coefficient of variation & linear skewness)
}
\details{
Growth factors are calculated by the method outlined in the Flood Estimation Handbook, volume 3, 1999.
}
\examples{
#Estimate the 50-year growth factors from an Lcv of 0.17.
GumbelGF(0.17, RP = 50)
}
\author{
Anthony Hammond
}
