% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select.R
\name{select}
\alias{select}
\title{Selectivity model}
\usage{
select(param, plot = FALSE)
}
\arguments{
\item{param}{a list with following parameters:
\itemize{
  \item \code{type} a string indicating which type of gear was used (options:
  "gillnet" or "trawl_net"),
  \item \code{midLengths} midlengths of size classes
  \item \code{meshSizes} a vector with mesh sizes in increasing order,
  \item \code{CatchPerNet_mat} a matrix with the catches per net in corresponding
  order of mesh sizes
}}

\item{plot}{logical; should the results be displayed graphically?}
}
\value{
A list with the input parameters and following list objects for type = "gillnet":
#' \itemize{
  \item \strong{classes.num}: numeric vector with length classes without a plus group,
  \item \strong{SNet1}: selection ogive net 1,
  \item \strong{SNet2}: selection ogive net 2,
  \item \strong{lnNet2_Net1}: logarithm ratio between nets,
  \item \strong{linear_mod}: linear model,
  \item \strong{LmNet1}: optimum length net 1,
  \item \strong{LmNet2}: optimum length net 2,
  \item \strong{SF}: selection factor,
  \item \strong{stand.dev}: standard deviation of selection factor.
}
and following objects for type = "trawl_net":
\itemize{
  \item \strong{classes.num}: numeric vector with length classes,
  \item \strong{SLobs}: observed selection ogive,
  \item \strong{SLest}: estimated selection ogive,
  \item \strong{lnSL}: logarithm of observed selection,
  \item \strong{linear_mod}: linear model,
  \item \strong{S1}: constant of selection curve,
  \item \strong{S2}: another constant of selection curve,
  \item \strong{L25}: length at which 25% of the fish are retained in the codend,
  \item \strong{L50}: length at which 50% of the fish are retained in the codend,
  \item \strong{L75}: length at which 75% of the fish are retained in the codend,
  \item \strong{SF}: selection factor.
}
}
\description{
This function estimates the selecitvity of gillnets and
   trawl nets from experimental catches.
}
\details{
This function estimates the fractions retained by each net, the
  optimum lengths for each net, the selection factor (SF), and the standard deviation
  of the factor (stand.dev). Calculations are based on a normal distribution with common spread.
  Assumptions of this method are, that (i) the optimum length Lm is proportional to the mesh
  size (Lm = SF * m), (ii) the selection curves are normally distributed with a common
  standard deviation, (iii) the nets have the same fishing power (same dimensions and material).
  Requirements for the experimental set-up are: selection curves corresponding to the two
  mesh sizes have to overlap, and the nets have to be set in the same area, during the
  same time.
  To calculate selection factor (SF), L25, L50 and L75 for trawl nets /fisheries.
}
\examples{
# Gillnet selectivity
data(tilapia)
out <- select(param = tilapia)
plot(out)

# Trawl selectivity
data(bream)
select(bream)

}
\references{
Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2). 407 p.
}
