% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTRFunctions.R
\name{diurnal_temp_variation_sinesqrt}
\alias{diurnal_temp_variation_sinesqrt}
\title{Hourly Temperature Variation using Sine and Square Root Functions}
\usage{
diurnal_temp_variation_sinesqrt(t, t_r, t_s, T_max, T_min, T_minp)
}
\arguments{
\item{t}{\code{numeric} hour or hours for temperature estimate.}

\item{t_r, t_s}{\code{numeric} sunrise and sunset hours (0-23).}

\item{T_max, T_min}{\code{numeric} maximum and minimum temperatures of current day (C).}

\item{T_minp}{\code{numeric} minimum temperature of following day (C).}
}
\value{
\code{numeric} temperature (C) at a specified hour.
}
\description{
The function estimates temperature for a specified hour using sine and square root functions \insertCite{Cesaraccio2001}{TrenchR}.
}
\examples{
  diurnal_temp_variation_sinesqrt(t      = 8, 
                                  t_r    = 6, 
                                  t_s    = 18, 
                                  T_max  = 30, 
                                  T_min  = 10, 
                                  T_minp = 12)

}
\references{
\insertAllCited{}
}
\seealso{
Other microclimate functions: 
\code{\link{air_temp_profile_neutral}()},
\code{\link{air_temp_profile_segment}()},
\code{\link{air_temp_profile}()},
\code{\link{degree_days}()},
\code{\link{direct_solar_radiation}()},
\code{\link{diurnal_radiation_variation}()},
\code{\link{diurnal_temp_variation_sineexp}()},
\code{\link{diurnal_temp_variation_sine}()},
\code{\link{monthly_solar_radiation}()},
\code{\link{partition_solar_radiation}()},
\code{\link{proportion_diffuse_solar_radiation}()},
\code{\link{solar_radiation}()},
\code{\link{surface_roughness}()},
\code{\link{wind_speed_profile_neutral}()},
\code{\link{wind_speed_profile_segment}()}
}
\concept{microclimate functions}
