% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Information.R
\name{JointInformation}
\alias{JointInformation}
\title{Joint Information of two splits}
\usage{
JointInformation(A1A2, A1B2, B1A2, B1B2)
}
\arguments{
\item{A1A2, A1B2, B1A2, B1B2}{Number of taxa common to splits A1 and A2 (etc.).}
}
\value{
\code{JointInformation} returns the joint phylogenetic information content
of two splits, measured in bits.
}
\description{
Calculates the joint phylogenetic information content of two splits:
that is, the information content of the two splits considered separately,
minus their mutual information (which would otherwise be counted twice).
}
\details{
Because some information is common to both splits (\code{SplitMutualInformation}),
the joint information of two splits will be less than the sum of the
information of the splits taken separately -- unless the splits are
contradictory.

Split Y1 is defined as dividing taxa into the two sets A1 and B1,
and Y2=A2:B2.

Consider partitions that divide eight terminals, labelled A to H.

\tabular{rcll}{
Bipartition 1:\tab ABCD:EFGH\tab A1 = ABCD\tab B1 = EFGH \cr
Bipartition 2:\tab ABC:DEFGH\tab A2 = ABC\tab B2 = DEFGH
}

This can be represented by an association matrix:

\tabular{rll}{
\tab \emph{A2} \tab \emph{B2} \cr
\emph{A1} \tab ABC  \tab D   \cr
\emph{B1} \tab      \tab EFGH
}

The joint information is given by
\code{JointInformation(3, 1, 0, 4)}.
}
\examples{
JointInformation(3, 1, 0, 4)

}
\author{
Martin R. Smith
}
\concept{Split information}
