% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot3.R
\name{Plot3}
\alias{Plot3}
\title{Pseudo-3D plotting}
\usage{
Plot3(
  x,
  y = NULL,
  z = NULL,
  pch = par("pch"),
  col = par("col"),
  bg = NA,
  cex = 1,
  axes = TRUE,
  frame.plot = axes,
  plot.bg = NA,
  fog = 1/2,
  shrink = 1/2,
  add = FALSE,
  ...
)
}
\arguments{
\item{x, y, z}{Coordinates of points to plot.}

\item{bg, cex, col, pch, add, axes, frame.plot, \dots}{Parameters passed to
\code{\link[=plot.default]{plot.default()}}.}

\item{plot.bg}{Colour with which to fill plot area, used as fog colour.}

\item{fog}{Numeric specifying amount of mist to apply to distant points.}

\item{shrink}{Numeric specifying degree to which size of plotted point
should reflect \code{z} position.}
}
\description{
\code{Plot3()} is an experimental function that generates
a two-dimensional plot with the impression of a third dimension
obtained through point scaling, overlap and fogging.
}
\examples{
Plot3(1:10, 1:10, 1:10, cex = 7, pch = 16, axes = FALSE, asp = 1)
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
