% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CSA.R
\docType{class}
\name{CSA-class}
\alias{CSA-class}
\alias{CSA}
\title{CSA Class}
\arguments{
\item{ID}{The ID of the CSA ID}

\item{Counterparty}{The counterparty the CSA is linked to}

\item{Currency}{The currency that the CSA applies to (can be a list of different currencies)}

\item{TradeGroups}{The trade groups that the CSA applies to}

\item{Values_type}{The type of the numerical values (can be "Actual" or "Perc" whereby the values are percentages of the MtM)}

\item{thres_cpty}{The maximum exposure that the counterparty can generate before collateral will need to be posted}

\item{thres_PO}{The maximum exposure that the processing organization can generate before collateral will need to be posted}

\item{MTA_cpty}{The minimum transfer amount for the counterparty}

\item{MTA_PO}{The minimum transfer amount for the processing organization}

\item{IM_cpty}{The initial margin that is posted by the counterparty}

\item{IM_PO}{The initial margin that is posted by the processing organization}

\item{mpor_days}{The margin period of risk in days}

\item{remargin_freq}{The frequency of re-margining the exposure in days}

\item{rounding}{The rounding amount of the transfers}
}
\value{
An object of type CSA
}
\description{
Creates a collateral agreement Object containing all the relevant data and methods regarding the maturity factor
 and the calculation of the exposures after applying the relevant threshold
}

\examples{


  csa_raw = read.csv(system.file("extdata", "CSA.csv", package = "Trading"),
  header=TRUE,stringsAsFactors = FALSE)

csas = list()
for(i in 1:nrow(csa_raw))
{
 csas[[i]] = CSA()
 csas[[i]]$PopulateViaCSV(csa_raw[i,])
}
}
\references{
Basel Committee: The standardised approach for measuring counterparty credit risk exposures
http://www.bis.org/publ/bcbs279.htm
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
