% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToxicoSet.R
\name{ToxicoSet}
\alias{ToxicoSet}
\title{ToxicoSet constructor}
\usage{
ToxicoSet(name, molecularProfiles = list(), cell = data.frame(),
  drug = data.frame(), sensitivityInfo = data.frame(),
  sensitivityRaw = array(dim = c(0, 0, 0)),
  sensitivityProfiles = matrix(), sensitivityN = matrix(nrow = 0, ncol
  = 0), perturbationN = array(NA, dim = c(0, 0, 0)),
  curationDrug = data.frame(), curationCell = data.frame(),
  curationTissue = data.frame(), datasetType = c("sensitivity",
  "perturbation", "both"), verify = TRUE)
}
\arguments{
\item{name}{A \code{character} string detailing the name of the dataset}

\item{molecularProfiles}{A \code{list} of ExpressionSet objects containing
molecular profiles}

\item{cell}{A \code{data.frame} containing the annotations for all the cell
lines profiled in the data set, across all data types}

\item{drug}{A \code{data.frame} containing the annotations for all the drugs
profiled in the data set, across all data types}

\item{sensitivityInfo}{A \code{data.frame} containing the information for the
sensitivity experiments}

\item{sensitivityRaw}{A 3 Dimensional \code{array} contaning the raw drug
dose – response data for the sensitivity experiments}

\item{sensitivityProfiles}{\code{data.frame} containing drug sensitivity profile
statistics such as IC50 and AUC}

\item{sensitivityN, perturbationN}{A \code{data.frame} summarizing the
available sensitivity/perturbation data}

\item{curationCell, curationDrug, curationTissue}{A \code{data.frame} mapping
the names for cells, drugs, and tissues used in the data set to universal
identifiers used between different ToxicoSet objects}

\item{datasetType}{A \code{character} string of "sensitivity",
"perturbation", or both detailing what type of data can be found in the
ToxicoSet, for proper processing of the data}

\item{verify}{\code{boolean} Should the function verify the ToxicoSet and
print out any errors it finds after construction?}
}
\value{
An object of class ToxicoSet
}
\description{
A constructor that simplifies the process of creating ToxicoSets, as well
as creates empty objects for data not provided to the constructor. Only
objects returned by this constructor are expected to work with the ToxicoSet
methods. For a much more detailed instruction on creating ToxicoSets, please
see the "CreatingToxicoSet" vignette.
}
