% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonoverlappingBuffers.R
\name{NonoverlappingBuffers}
\alias{NonoverlappingBuffers}
\title{Non-overlapping buffers}
\usage{
NonoverlappingBuffers(buffPolys, unbuffPolys)
}
\arguments{
\item{buffPolys}{\link[sp]{SpatialPolygonsDataFrame}. A set of buffered tiles.}

\item{unbuffPolys}{\link[sp]{SpatialPolygonsDataFrame}. A set of unbuffered tiles.}
}
\value{
A \link[sp]{SpatialPolygonsDataFrame} corresponding to the tiles input in \code{buffPolys}
and \code{unbuffPolys} with all overlapping buffer areas removed.
}
\description{
Takes a set of tiles and removes all overlapping buffer areas, while conserving buffer areas along
the edge of the tile set.
}
\details{
When processing a tiled dataset, using buffered tiles can help remove the edge effects along the
individual tile borders. However, overlapping buffers generally need to be removed when recombining
a series of tiles back into a single raster. Although this can be accomplished by using the unbuffered
tile extent, this will also remove the buffered areas along the edge of the tile set. Once these
unbuffered tiles are reassembled, the resulting raster will then be smaller than the original
dataset before it was tiled.

This may not be a desirable result. The \code{NonoverlappingBuffers} function will produce a set of
polygons that correspond to the tile extents that conserve buffers only where they do not overlap onto
neighbouring tiles (i.e.: along the edge of the tile set). These polygons are useful for cropping out
overlapping areas from buffered tiles in order to reassemble the tiles into a single raster.

Typically, both inputs for this function would be generated by the \code{\link{TileScheme}} function.

Both \code{buffPolys} and \code{unbuffPolys} should represent the same set of tiles. Both require
'col' and 'row' data columns indicating each cell's column and row number.
}

