% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-aic-poisson.R
\name{util_poisson_aic}
\alias{util_poisson_aic}
\title{Calculate Akaike Information Criterion (AIC) for Poisson Distribution}
\usage{
util_poisson_aic(.x)
}
\arguments{
\item{.x}{A numeric vector containing the data to be fitted to a Poisson distribution.}
}
\value{
The AIC value calculated based on the fitted Poisson distribution to the provided data.
}
\description{
This function estimates the lambda parameter of a Poisson distribution from the
provided data and then calculates the AIC value based on the fitted distribution.
}
\details{
This function calculates the Akaike Information Criterion (AIC) for a Poisson
distribution fitted to the provided data.

This function fits a Poisson distribution to the provided data. It estimates the
lambda parameter of the Poisson distribution from the data. Then, it calculates
the AIC value based on the fitted distribution.

Initial parameter estimates: The function uses the method of moments estimate
as a starting point for the lambda parameter of the Poisson distribution.

Optimization method: Since the parameter is directly calculated from the data,
no optimization is needed.

Goodness-of-fit: While AIC is a useful metric for model comparison,
it's recommended to also assess the goodness-of-fit of the chosen model using
visualization and other statistical tests.
}
\examples{
# Example 1: Calculate AIC for a sample dataset
set.seed(123)
x <- rpois(100, lambda = 2)
util_poisson_aic(x)

}
\seealso{
Other Utility: 
\code{\link{check_duplicate_rows}()},
\code{\link{convert_to_ts}()},
\code{\link{quantile_normalize}()},
\code{\link{tidy_mcmc_sampling}()},
\code{\link{util_beta_aic}()},
\code{\link{util_binomial_aic}()},
\code{\link{util_cauchy_aic}()},
\code{\link{util_chisq_aic}()},
\code{\link{util_exponential_aic}()},
\code{\link{util_f_aic}()},
\code{\link{util_gamma_aic}()},
\code{\link{util_generalized_beta_aic}()},
\code{\link{util_generalized_pareto_aic}()},
\code{\link{util_geometric_aic}()},
\code{\link{util_hypergeometric_aic}()},
\code{\link{util_inverse_burr_aic}()},
\code{\link{util_inverse_pareto_aic}()},
\code{\link{util_inverse_weibull_aic}()},
\code{\link{util_logistic_aic}()},
\code{\link{util_lognormal_aic}()},
\code{\link{util_negative_binomial_aic}()},
\code{\link{util_normal_aic}()},
\code{\link{util_paralogistic_aic}()},
\code{\link{util_pareto1_aic}()},
\code{\link{util_pareto_aic}()},
\code{\link{util_t_aic}()},
\code{\link{util_triangular_aic}()},
\code{\link{util_uniform_aic}()},
\code{\link{util_weibull_aic}()},
\code{\link{util_zero_truncated_binomial_aic}()},
\code{\link{util_zero_truncated_geometric_aic}()},
\code{\link{util_zero_truncated_negative_binomial_aic}()},
\code{\link{util_zero_truncated_poisson_aic}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility}
