% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_functions.R
\docType{methods}
\name{calcHessian}
\alias{calcHessian}
\alias{calcHessian,item_1PL,numeric,numeric-method}
\alias{calcHessian,item_1PL,numeric-method}
\alias{calcHessian,item_2PL,numeric,numeric-method}
\alias{calcHessian,item_2PL,numeric-method}
\alias{calcHessian,item_3PL,numeric,numeric-method}
\alias{calcHessian,item_3PL,numeric-method}
\alias{calcHessian,item_PC,numeric,numeric-method}
\alias{calcHessian,item_PC,numeric-method}
\alias{calcHessian,item_GPC,numeric,numeric-method}
\alias{calcHessian,item_GPC,numeric-method}
\alias{calcHessian,item_GR,numeric,numeric-method}
\alias{calcHessian,item_GR,numeric-method}
\alias{calcHessian,item_pool,numeric,numeric-method}
\alias{calcHessian,item_pool,numeric-method}
\alias{calcHessian,item_pool_cluster,numeric,list-method}
\alias{calcHessian,item_pool_cluster,numeric-method}
\title{Calculate second derivative of log-likelihood}
\usage{
calcHessian(object, theta, resp)

\S4method{calcHessian}{item_1PL,numeric,numeric}(object, theta, resp)

\S4method{calcHessian}{item_2PL,numeric,numeric}(object, theta, resp)

\S4method{calcHessian}{item_3PL,numeric,numeric}(object, theta, resp)

\S4method{calcHessian}{item_PC,numeric,numeric}(object, theta, resp)

\S4method{calcHessian}{item_GPC,numeric,numeric}(object, theta, resp)

\S4method{calcHessian}{item_GR,numeric,numeric}(object, theta, resp)

\S4method{calcHessian}{item_pool,numeric,numeric}(object, theta, resp)

\S4method{calcHessian}{item_pool_cluster,numeric,list}(object, theta, resp)
}
\arguments{
\item{object}{an \code{\link{item}} or an \code{\linkS4class{item_pool}} object.}

\item{theta}{theta values to use.}

\item{resp}{the response data to use. This must be a single value for an \code{\link{item}}, or a length \emph{ni} vector for an \code{\linkS4class{item_pool}}.}
}
\value{
\describe{
  \item{\code{\link{item}} object:}{\code{\link{calcHessian}} returns a length \emph{nq} vector containing the second derivative of the log-likelihood function, of observing the response at each theta.}
  \item{\code{\linkS4class{item_pool}} object:}{\code{\link{calcHessian}} returns a (\emph{nq}, \emph{ni}) matrix containing the second derivative of the log-likelihood function, of observing the response at each theta.}
}
}
\description{
\code{\link{calcHessian}} is a function to calculate the second derivative of the log-likelihood function.
}
\details{
\describe{
  \item{\emph{notations}}{\itemize{
    \item{\emph{nq} denotes the number of theta values.}
    \item{\emph{ni} denotes the number of items in the \code{\linkS4class{item_pool}} object.}
  }}
}
}
\examples{

item_1    <- new("item_1PL", difficulty = 0.5)
item_2    <- new("item_2PL", slope = 1.0, difficulty = 0.5)
item_3    <- new("item_3PL", slope = 1.0, difficulty = 0.5, guessing = 0.2)
item_4    <- new("item_PC", threshold = c(-1, 0, 1), ncat = 4)
item_5    <- new("item_GPC", slope = 1.2, threshold = c(-0.8, -1.0, 0.5), ncat = 4)
item_6    <- new("item_GR", slope = 0.9, category = c(-1, 0, 1), ncat = 4)

h_item_1 <- calcHessian(item_1, seq(-3, 3, 1), 0)
h_item_2 <- calcHessian(item_2, seq(-3, 3, 1), 0)
h_item_3 <- calcHessian(item_3, seq(-3, 3, 1), 0)
h_item_4 <- calcHessian(item_4, seq(-3, 3, 1), 0)
h_item_5 <- calcHessian(item_5, seq(-3, 3, 1), 0)
h_item_6 <- calcHessian(item_6, seq(-3, 3, 1), 0)
h_pool   <- calcHessian(
  itempool_science, seq(-3, 3, 1),
  rep(0, itempool_science@ni)
)

}
\references{
Rasch, G. (1960). \emph{Probabilistic models for some intelligence and attainment tests.}
Copenhagen: Danish Institute for Educational Research.

Lord, F. M. (1952). A theory of test scores (Psychometric Monograph No. 7). Richmond, VA: Psychometric Corporation.

Birnbaum, A. (1957). \emph{Efficient design and use of tests of mental ability for various decision-making problems}
(Series Report No. 58-16. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{On the estimation of mental ability}
(Series Report No. 15. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{Further considerations of efficiency in tests of a mental ability}
(Series Report No. 17. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1968). Some latent trait models and their use in inferring an examinee's ability.
In Lord, F. M., Novick, M. R. (eds.), \emph{Statistical Theories of Mental Test Scores}, 397-479.
Reading, MA: Addison-Wesley.

Masters, G. N. (1982). A Rasch model for partial credit scoring.
\emph{Psychometrika, 47}(2), 149-174.

Andrich, D. (1978). A rating formulation for ordered response categories.
\emph{Psychometrika, 43}(4), 561-573.

Muraki, E. (1992). A generalized partial credit model: Application of an EM algorithm.
\emph{Applied Psychological Measurement, 16}(2), 159-176.

Samejima, F. (1969). Estimation of latent ability using a response pattern of graded scores.
\emph{Psychometrika Monograph, 17}.
}
