% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow_functions.R
\name{item_pool.operators}
\alias{item_pool.operators}
\alias{+.item_pool}
\alias{-.item_pool}
\alias{==.item_pool}
\alias{==.pool_cluster}
\title{Item pool and pool cluster operators}
\usage{
\method{+}{item_pool}(pool1, pool2)

\method{-}{item_pool}(pool1, pool2)

\method{==}{item_pool}(pool1, pool2)

\method{==}{pool_cluster}(pool_cluster1, pool_cluster2)
}
\arguments{
\item{pool1}{An \code{\linkS4class{item_pool}} object.}

\item{pool2}{An \code{\linkS4class{item_pool}} object.}

\item{pool_cluster1}{A \code{\linkS4class{pool_cluster}} object.}

\item{pool_cluster2}{A \code{\linkS4class{pool_cluster}} object.}
}
\description{
\code{pool1 + pool2} combines two \code{\linkS4class{item_pool}} objects.

\code{pool1 - pool2} excludes the items in the second item pool from the first. The two \code{\linkS4class{item_pool}} objects must overlap for this to be performed.

\code{pool1 == pool2} tests equality of the two item_pool objects.

\code{pool_cluster1 == pool_cluster2} tests equality of the two pool_cluster objects.
}
\examples{
itempool <- itempool_science + itempool_reading

subitempool <- subsetItemPool(itempool_science, 1:500)
itempool <- itempool_science - subitempool

itempool <- subsetItemPool(itempool_science, 1:500)
subitempool1 <- itempool_science - itempool
subitempool2 <- subsetItemPool(itempool_science, 501:1000)
subitempool1 == subitempool2  ## TRUE

cluster1 <- makeItemPoolCluster(c(itempool_science, itempool_reading))
cluster2 <- makeItemPoolCluster(c(cluster1@pools[[1]], cluster1@pools[[2]]))
cluster1 == cluster2  ## TRUE

}
