% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cbPalette8}
\alias{cbPalette8}
\title{Eight-colour palette compatible with colour blindness}
\format{An object of class \code{character} of length 8.}
\source{
\cite{Wong B. 2011. Color blindness. Nat. Methods. 8:441. \doi{10.1038/nmeth.1618}}
}
\usage{
cbPalette8
}
\description{
An eight-colour palette recommended for use with colour blind audiences.
}
\examples{
{
data('cbPalette8')
dev.new(width=8, height=1, units='cm')
par(mar=rep(0, 4))
plot(0, type='n', xlim=c(1, 8), ylim=c(0, 1), axes=FALSE)
points(1:8, rep(0, 8), col=cbPalette8, pch=15)
text(1:8, 0.5, col=cbPalette8)
}

}
\seealso{
\link{cbPalette15}
}
\keyword{datasets}
