% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenGamma.R
\name{fit.GenGamma}
\alias{fit.GenGamma}
\title{Generalized Gamma Distribution Parameter Estimation}
\usage{
fit.GenGamma(time, status, sig = 0.05, init = NULL, eps = 1e-06,
  maxit = 10, report = F)
}
\arguments{
\item{time}{Observation times.}

\item{status}{Status indicator, coded as 1 if an event was observed, 0 if censored.}

\item{sig}{Significance level, for CIs.}

\item{init}{List of initial parameter values, including the logs of the shape
parameters "la" and "lb", and the log of the rate parameter "ll".}

\item{eps}{Tolerance for Newton-Raphson iterations.}

\item{maxit}{Maximum number of NR iterations.}

\item{report}{Report fitting progress?}
}
\value{
An object of class \code{fit} containing the following:
\describe{
 \item{Parameters}{The estimated shape \eqn{(\alpha,\beta)} and rate \eqn{\lambda} parameters.}
 \item{Information}{The observed information matrix.}
 \item{Outcome}{The fitted mean, median, and variance.}
}
}
\description{
Estimates parameters for generalized gamma event times subject to non-informative
right censoring. The gamma distribution is parameterized in terms
of the shape parameters \eqn{(\alpha,\beta)}, and the rate \eqn{\lambda}:
\deqn{f(t) = \frac{\beta\lambda}{\Gamma(\alpha)} (\lambda t)^{\alpha\beta-1}e^{-(\lambda t)^{\beta}}, t>0}
}
\examples{
set.seed(100);
# Simulate
D = rGenGamma(n=1e4,a=2,b=2,l=2);
# Estimate
M = fitParaSurv(time=D$time,status=D$status,dist="gengamma");
}
\seealso{
\itemize{
  \item{Fitting function for parametric survival distributions \code{\link{fitParaSurv}}}
}
}
