% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TUFLOW.R
\name{TFVPlotagainstObserved}
\alias{TFVPlotagainstObserved}
\title{ggplot of TFV model runs and observed data}
\usage{
TFVPlotagainstObserved(
  Sim,
  Obs,
  ylab,
  file,
  width = 17,
  height = 22,
  order = NULL,
  scales = "fixed",
  cols = NULL,
  newnames = NULL,
  ylim = NA,
  nlegendrow = 1
)
}
\arguments{
\item{Sim}{modelled output, imported using 'TFVGetResults()'}

\item{Obs}{observed data. This is bind_rows() to Sim, so requires the same columns and headings. Obs can be NULL if all data of interest is in Sim}

\item{ylab}{label for y axis}

\item{file}{file to save figure to}

\item{width}{width of image in cm, default to 17}

\item{height}{height of image in cm, default to 22}

\item{order}{character vector of site IDs to order the plots in. Default to NULL, which will plot in alphabetical order}

\item{scales}{control the y axis scales across the facets plots. default to fixed, the same scale across all plots. Change to free_y to have scales dependent on the data for each plot}

\item{cols}{vector of colours to plot each line. Defaults to DEW style 2 greens and 2 blues. Defaults will fail if more than 4 RunNames.}

\item{newnames}{named vector to label the facets on the plot. vector elements should be the new text to use, names should be the names in the data}

\item{ylim}{- specify y axis limits manually as two number vector, e.g. c(0,1)}

\item{nlegendrow}{- specify the number of rows in the legend, increase this if the scenario names go off the figure. Defaults to 1}
}
\value{
Nothing is returned to the R environment. The generated figure is saved to file.
}
\description{
ggplot of TFV model runs and observed data
}
\examples{
\dontrun{
stations<-c("A4261043", "A4261134","A4261135","A4260572","A4260633","A4261209","A4261165")
TFVPlotagainstObserved(Sim,Obs,"Salinity (g/L)","salinity.png",order=stations)
}

}
