% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TUFLOW.R
\name{TFVGetResults}
\alias{TFVGetResults}
\title{Read in one variable out of a TFV POINTS File. Assumes the points file ID is a observation station site ID.}
\usage{
TFVGetResults(
  Resultfile,
  parameter,
  RunName,
  stations = NULL,
  dailyaverage = FALSE
)
}
\arguments{
\item{Resultfile}{TUFLOW output POINTS file}

\item{parameter}{- parameter to plot, must be in column heading, e.g. "SAL"}

\item{RunName}{- name of model run to add to a column, for ease of combining/plotting}

\item{stations}{- list of stations to return, to subset from everything recorded. default to NULL, which will return all.}

\item{dailyaverage}{- set to TRUE to average sub daily data to daily time step}
}
\value{
tibble with data in long format, with columns: Time, Site, Value, Data
}
\description{
Read in one variable out of a TFV POINTS File. Assumes the points file ID is a observation station site ID.
}
\examples{
\dontrun{
TFVGetResults("Results_POINTS.csv","SAL","TFV",c("A4261209","A4261165"))
}

}
