% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_based_repr.R
\name{coefComp}
\alias{coefComp}
\alias{lmCoef}
\alias{coefComp}
\alias{rlmCoef}
\alias{coefComp}
\alias{l1Coef}
\title{Functions for linear regression model coefficients extraction}
\usage{
lmCoef(X, Y)

rlmCoef(X, Y)

l1Coef(X, Y)
}
\arguments{
\item{X}{the model (design) matrix of independent variables}

\item{Y}{the vector of dependent variable (time series)}
}
\value{
The numeric vector of regression coefficients
}
\description{
The functions computes regression coefficients from a linear model.
}
\examples{
design_matrix <- matrix(rnorm(10), ncol = 2)
lmCoef(design_matrix, rnorm(5))

rlmCoef(design_matrix, rnorm(5))

l1Coef(design_matrix, rnorm(5))

}
\seealso{
\code{\link[stats]{lm}, \link[MASS]{rlm}, \link[quantreg]{rq}}
}
\author{
Peter Laurinec, <tsreprpackage@gmail.com>
}
