# write a simple TSPLIB format file from an object of class TSP
# (contains a dist object or a symmetric matrix) 

write_TSPLIB <- function(x, file, precision = 6, inf = NULL) {
    
    if(!inherits(x, "TSP")) x <- TSP(x)
  
    # Concorde can handle UPPER_ROW and dist (lower triangle matrix) 
    # is symmetric.
    format <- "EDGE_WEIGHT_FORMAT: UPPER_ROW"
    
    zz <- file(file, "w")

    cat("NAME: tsp",
        "COMMENT: generated by write_TSPLIB (R package tsp)",
        "TYPE: TSP",
        paste("DIMENSION:", n_of_cities(x)),
        "EDGE_WEIGHT_TYPE: EXPLICIT",
        format, 
        file = zz, sep = "\n")
    
    # fixes for TSPLIB/Concorde
    # infinity is not available so we use a relatively large number
    inf_index <- is.infinite(x)
    if(is.null(inf)) inf <- max(x[!inf_index]) * 2
    if(any(inf_index)) {
        x[inf_index] <- inf
    }
    
    # only integers can be used as weights
    if(storage.mode(x) != "integer") x <- as.integer(x * 10^precision)

    cat("EDGE_WEIGHT_SECTION", x, file = zz, sep = "\n")
    cat("EOF", file = zz, sep = "\n")

    close(zz)
}

