% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tscsEstimate3D.R
\name{tscsEstimate3D}
\alias{tscsEstimate3D}
\title{The Second Step of TSCS for 3D Rectangular Grid System - Estimation}
\usage{
tscsEstimate3D(matrix, newdata, h1, h2, v)
}
\arguments{
\item{matrix}{data frame; the first return value \code{coef_matrix} of function \code{tscsRegression3D}
in the first step of TSCS.}

\item{newdata}{data frame; should only contain the four variables in order: X coordinate, Y coordinate, Z coordinate
and observation. This is the cross-section data or pure spatial data of a particular time point you have selected,
with missing observations that you want to predict. (coordinates must be numeric)}

\item{h1}{numeric; side length of the unit cubic grid in X coordinate direction (horizontal).}

\item{h2}{numeric; side length of the unit cubic grid in Y coordinate direction (horizontal).}

\item{v}{numeric; side length of the unit cubic grid in Z coordinate direction (vertical).}
}
\value{
A list of 3 is returned, including:
\describe{
  \item{\code{estimate}}{data frame; estimate of missing observations which contains the 4 variables in order:
  X coordinate, Y coordinate, Z coordinate and estimation.}
  \item{\code{complete}}{data frame; an updated version of the cross-section data (pure spatial data) \code{newdata},
  with all of its missing observations interpolated.}
  \item{\code{NA_id}}{an integer vector; reveals the instance ID, in data frame \code{newdata},
  of spatial locations with missing observation.}
}
}
\description{
\code{tscsEstimate} estimates the missing observations within the cross-section data (pure spatial data)
  of a particular time point you have selected, namely, the interpolation process.
}
\details{
\itemize{
  \item The first step of TSCS spatial interpolation should be carried out by function \code{tscsRegression3D},
  which is the prerequisite of \code{tscsEstimate3D}.
  \item For 2D rectangular grid system, the procedure of TSCS stays the same.
  Please see \code{tscsRegression} and \code{tscsEstimate}.
  \item Attentions:
  Since TSCS is only capable of interpolation but not extrapolation, please make sure that
  the missing observations in a given spatial domain are all located at interior spatial locations.
  Otherwise, extrapolation would occur with an error following.
}
}
\examples{
\dontrun{

## TSCS spatial interpolation procedure:

basis <- tscsRegression3D(data = data, h1 = 3.75, h2 = 2.5, v = 5, alpha = 0.01);
basis$percentage
est <- tscsEstimate3D(matrix = basis$coef_matrix, newdata = newdata, h1 = 3.75, h2 = 2.5, v = 5);
str(est)

## comparison of estimates and true values:

plot_compare(est = est$estimate[,4], true = true)
index <- appraisal_index(est = est$estimate[,4], true = true);
index

## data visualization:

plot3D_dif(data = data[,1:3], h1 = 3.75, h2 = 2.5, v = 5)
plot3D_NA(newdata = newdata)
plot3D_map(newdata = newdata)
}
}
\seealso{
\code{tscsRegression3D}, \code{tscsEstimate}, \code{plot3D_NA}, \code{plot3D_map}
}
