% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kroncov.R
\name{kroncov}
\alias{kroncov}
\title{The covariance estimation of a tensor random variable}
\usage{
kroncov(Tn)
}
\arguments{
\item{Tn}{A \eqn{p_1\times\cdots p_m\times n} matrix, array or tensor, where \eqn{n} is the sample size.}
}
\value{
\item{lambda}{The normalizing constant.}
\item{S}{A matrix list, consisting of each normalized covariance matrix \eqn{\boldsymbol{\Sigma}_1,\ldots,\boldsymbol{\Sigma}_m}.}
}
\description{
This function estimates the covariance of a tensor random variable. We assume the covariance of the tensor random variable has a separable Kronecker covariance structure, i.e. \eqn{\boldsymbol{\Sigma}=\boldsymbol{\Sigma}_{m}\otimes\cdots\otimes\boldsymbol{\Sigma}_{1}}. This algorithm is described in Manceur, A. M., & Dutilleul, P. (2013).
}
\details{
The individual component covariance matrices \eqn{\boldsymbol{\Sigma}_i, i=1,\ldots, m} are not identifiable. So each matrix is normalized, and an overall normalizing constant \eqn{\lambda} is extract, which is defined as
\deqn{\boldsymbol{\Sigma}=\lambda \boldsymbol{\Sigma}_m \otimes \cdots \otimes \boldsymbol{\Sigma}_1.}
}
\references{
Manceur, A. M., & Dutilleul, P. (2013). Maximum likelihood estimation for the tensor normal distribution: Algorithm, minimum sample size, and empirical bias and dispersion. Journal of Computational and Applied Mathematics, 239, 37-49.
}
