% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FG_TPR.R
\name{FG_TPR-deprecated}
\alias{FG_TPR-deprecated}
\title{Envelope estimation of tensor predictor regression (TPR) with the full Grassmannian optimization}
\usage{
FG_TPR(Xn, Yn, Gamma_init)
}
\arguments{
\item{Xn}{The predictor tensor instance or dimension \eqn{p_1\times p_2\times\cdots\times p_m \times n}, where \eqn{n} is the sample size.}

\item{Yn}{The predictor matrix of dimension \eqn{r \times n}.}

\item{Gamma_init}{The initial estimation of envelope subspace basis, can be derived from \code{TPR.fit}.}
}
\value{
\describe{
 \item{Bhat}{The estimation of regression coefficient tensor.}
 \item{Gamma_hat}{The FG estimation of envelope subspace basis.}
}
}
\description{
This function is used for envelope estimation of tensor predictor regression with the full Grassmannian (FG) optimization.
}
\examples{
rm(list = ls())
p <- c(10, 10, 10)
u <- c(1, 1, 1)
m <- 3; r <- 5; n <- 200
eta <- array(runif(prod(u,r)), c(u,r))
eta <- rTensor::as.tensor(eta)

Gamma <- Gamma0 <- Omega <- Omega0 <- Sig <- Sigsqrtm <- NULL
for(i in 1:m) {
  tmp <- matrix(runif(p[i]*u[i]), p[i], u[i])
  Gamma[[i]] <- qr.Q(qr(tmp))
  Gamma0[[i]] <- qr.Q(qr(tmp), complete=TRUE)[, (u[i]+1):p[i]]
  Omega[[i]] <- diag(u[i])
  Omega0[[i]] <- 0.01*diag(p[i]-u[i])
  Sig[[i]] <- Gamma[[i]] \%*\% Omega[[i]] \%*\% t(Gamma[[i]])+
    Gamma0[[i]] \%*\% Omega0[[i]] \%*\% t(Gamma0[[i]])
  Sig[[i]] <- 2*Sig[[i]]/norm(Sig[[i]], type="F")
  Sigsqrtm[[i]] <- pracma::sqrtm(Sig[[i]])$B
}

B <- rTensor::ttl(eta,Gamma, ms = c(1:m))
A <- matrix(runif(r^2), r, r)
SigY <- A \%*\% t(A)
SigY <- SigY/norm(SigY, type="F")
##generate data
Epsilon <- MASS::mvrnorm(n, mu=rep(0, r), Sigma=SigY)
tmp2 <- array(rnorm(prod(p, n)), c(p, n))
Xn <- rTensor::as.tensor(tmp2)
Xn <- rTensor::ttl(Xn, Sigsqrtm, ms = c(1:m))
vecXn <- matrix(Xn@data, prod(p), n)
Y_tmp <- matrix(NA, r, n)
tmp <- array(NA, c(p, r))
for (j in 1:n) {
  for (s in 1:r) {
    tmp[, , , s] <-  B@data[, , , s]*Xn@data[, , , j]
  }
  Y_tmp[, j] <- apply(tmp, 4, sum)
}
Yn <-  Y_tmp + t(Epsilon)

# use the result of 1D method as the initial value
res_1D = TPR.fit(Xn, Yn, u, method="1D")
\dontrun{
  res_FG = FG_TPR(Xn, Yn, Gamma_init=res_1D$Gamma_hat)
}

}
\seealso{
\code{\link{TRES-deprecated}}
}
\keyword{internal}
