% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tropical.HAR.Gaussian.R
\name{tropical.Gaussian}
\alias{tropical.Gaussian}
\alias{tropical.gaussian}
\title{Tropical Gaussian sampling about a center of mass}
\usage{
tropical.gaussian(D_s, x0, I = 1, M, S)
}
\arguments{
\item{D_s}{matrix of vertices of a tropical simplex; each row is a vertex}

\item{x0}{initial point for sampler, numeric vector}

\item{I}{number of states in Markov chain}

\item{M}{location parameter; numeric vector indicating centroid}

\item{S}{scale parameter; in terms of tropical distance}
}
\value{
next sampled point from the tropical polytope
}
\description{
This function is a Gaussian-like HAR sampler about a center of mass denoted by a location parameter with scale parameter in terms of the tropical distance
}
\examples{
D_s <-matrix(c(0,0,0,0,10,0,0,0,10),3,3,TRUE)
x0 <- c(0,0,0)
M <- c(0,5,5)
S <- 2
tropical.gaussian(D_s, x0, I = 50,M,S)
}
\author{
David Barnhill \email{david.barnhill@nps.edu}
}
