% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_TL.plateau.R
\name{plot_TL.plateau}
\alias{plot_TL.plateau}
\title{plot plateau test result}
\usage{
plot_TL.plateau(sample.name, temperatures, names, doses, Lx, Lx.a, Lx.plateau,
  LxTx, LxTx.a, LxTx.plateau, plotting.parameters = list(plateau.Tmin = 0,
  plateau.Tmax = NA, plot.Tmin = 0, plot.Tmax = NA))
}
\arguments{
\item{sample.name}{\link{character} (\bold{required}): Sample name.}

\item{temperatures}{\link{numeric} (\bold{required}): temperature vector}

\item{names}{\link{character} (\bold{required}): Name vector for the additive curves.}

\item{doses}{\link{numeric} (\bold{required}): Dose vector for the additive curves.}

\item{Lx}{\link{numeric} (\bold{required}): Lx matrix for the additive curves.}

\item{Lx.a}{\link{numeric} (\bold{required}): Lx matrix for the average additive curves.}

\item{Lx.plateau}{\link{numeric} (\bold{required}): Ln/Lx matrix for the additive curves.}

\item{LxTx}{\link{numeric} (\bold{required}): Lx/Tx matrix for the additive curves.}

\item{LxTx.a}{\link{numeric} (\bold{required}): Lx/Tx matrix for the average additive curves.}

\item{LxTx.plateau}{\link{numeric} (\bold{required}): (Ln/Tn)/(Lx/Tx) matrix for the additive curves.}

\item{plotting.parameters}{\link{list} (with default): list containing the plotting parameters. See details.}
}
\description{
This function plots the results for \link{analyse_TL.plateau}.
}
\details{
\bold{Plotting parameters} \cr
The plotting parameters are:  \cr
\describe{
 \item{\code{plot.Tmin}}{
   \link{numeric}: Lowest temperature plotted.}
 \item{\code{plot.Tmax}}{
   \link{numeric}: Highest temperature plotted.}
 \item{\code{no.plot}}{
   \link{logical}: If \code{TRUE}, the results will not be plotted.}
}
See also \link{analyse_TL.MAAD}. \cr
}
\author{
David Strebler
}
\seealso{
\link{analyse_TL.plateau},
 \link{calc_TL.MAAD.fit.Q},
 \link{calc_TL.MAAD.fit.I}.
}

