% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TFM.R
\name{TFM}
\alias{TFM}
\title{The TFM function is to generate Truncated factor model data.}
\usage{
TFM(n, mu, sigma, lower, upper, distribution_type)
}
\arguments{
\item{n}{Total number of observations.}

\item{mu}{The mean of the distribution.}

\item{sigma}{The parameter of the distribution.}

\item{lower}{The lower bound of the interval.}

\item{upper}{The upper bound of the interval.}

\item{distribution_type}{String specifying the distribution type to use.}
}
\value{
A list containing:
\item{X}{A matrix of generated truncated factor model data based on the specified distribution type. Each row corresponds to an observation, and each column corresponds to a variable.}
}
\description{
The TFM function generates truncated factor model data supporting various distribution types for related analyses using multiple methods.
}
\examples{
library(relliptical)
set.seed(123)
mu <- c(0, 1)
n <- 100
sigma <- matrix(c(1, 0.70, 0.70, 3), 2, 2)
lower <- c(-2, -3)
upper <- c(3, 3)
distribution_type <- "truncated_normal"
X <- TFM(n, mu, sigma, lower, upper, distribution_type)
}
