#' LTR retrotransposons in \emph{Arabidopsis lyrata}
#'
#' This data file contains the LTR retrotransposons in \emph{Arabidopsis lyrata}.
#'
#' @name AlyLTR
#' @docType data
#' @format A data frame with 397 rows and 7 columns. Each row corresponds to a unique LTR retrotransposon, and each column corresponds to a feature of the LTR-RT. The columns are:
#' \describe{
#' \item{SeqID}{LTR retrotransposon sequence ID}
#' \item{UngapedLen}{Length of each LTR}
#' \item{Mismatch}{Number of mismatches}
#' \item{Distance}{Divergence, as defined by (# of mismatches) / (LTR length)}
#' \item{sup}{Super family membership}
#' \item{GroupID}{LTR retrotransposon Family ID}
#' \item{thaID}{Family name matched in the LTR-RT families of A. thaliana}
#' } 
#' @references
#' \cite{Lamesch, Philippe, Tanya Z. Berardini, Donghui Li, David Swarbreck, Christopher Wilks, Rajkumar Sasidharan, Robert Muller et al. "The Arabidopsis Information Resource (TAIR): improved gene annotation and new tools." Nucleic acids research 40, no. D1 (2011): D1202-D1210.}
#'
#' \cite{Dai, X., Wang, H., Dvorak, J., Bennetzen, J., Mueller, H.-G. (2018+). "Birth and Death of LTR Retrotransposons in Aegilops tauschii"}
NULL

