% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCGAretr_scr.R
\name{get_profile_data}
\alias{get_profile_data}
\title{Retrieve TCGA Data corresponding to a Specific Genetic Profile of Interest}
\usage{
get_profile_data(case_id = NULL, gprofile_id = NULL, glist = NULL)
}
\arguments{
\item{case_id}{String corresponding to the Identifier of a list of cases}

\item{gprofile_id}{String corresponding to the Identifier of a genetic Profile of interest}

\item{glist}{Character vector including one or more gene identifiers (ENTREZID or OFFICIAL_SYMOL)}
}
\value{
data.frame with one row per gene and one column per case/sample
}
\description{
Retrieve Data corresponding to a Genetic Profile of interest from a given TCGA Study. 
This function is the workhorse of the TCGAretriever package and can be used to fetch data 
concerning several genes at once. For larger queries, the use of the fetch_all_tcgadata() 
function is mandatory
}
\examples{
get_profile_data("blca_tcga_all", "blca_tcga_mutations", c("TP53", "E2F1"))

}
\references{
\itemize{
  \item \url{http://www.biotechworld.it/bioinf/2016/07/11/tcga-data-via-tcgaretriever/}
  \item \url{https://www.data-pulse.com/dev_site/TCGAretriever/}
}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
