% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.Learner.R
\name{create.Learner}
\alias{create.Learner}
\title{Factory for learner wrappers}
\usage{
create.Learner(base_learner, params = list(), tune = list(),
  env = parent.frame(), name_prefix = base_learner, detailed_names = F,
  verbose = F)
}
\arguments{
\item{base_learner}{Character string of the learner function that will be
customized.}

\item{params}{List with parameters to customize.}

\item{tune}{List of hyperparameter settings that will define custom learners.}

\item{env}{Environment in which to create the functions. Defaults
to the current environment (e.g. often the global environment).}

\item{name_prefix}{The prefix string for the name of each function that is
generated.}

\item{detailed_names}{Set to T to have the function names include the
parameter configurations.}

\item{verbose}{Display extra details.}
}
\value{
Returns a list with expanded tuneGrid and the names of the created
  functions.
}
\description{
Create custom learners and/or a sequence of learners with hyperparameter
combinations defined over a grid.
}
\examples{
\dontrun{
# Create a randomForest learner with ntree set to 1000 rather than the
# default of 500.
create_rf = create.Learner("SL.randomForest", list(ntree = 1000))
create_rf
sl = SuperLearner(Y = Y, X = X, SL.library = create_rf$names, family = binomial())
sl
# Clean up global environment.
rm(list = create_rf$names)
# Create a randomForest learner that optimizes over mtry
create_rf = create.Learner("SL.randomForest",
                     tune = list(mtry = round(c(1, sqrt(ncol(X)), ncol(X)))))
create_rf
sl = SuperLearner(Y = Y, X = X, SL.library = create_rf$names, family = binomial())
sl
# Clean up global environment.
rm(list = create_rf$names)

# Optimize elastic net over alpha, with a custom environment and detailed names.
learners = new.env()
create_enet = create.Learner("SL.glmnet", env = learners, detailed_names = T,
                           tune = list(alpha = seq(0, 1, length.out=5)))
create_enet
# List the environment to review what functions were created.
ls(learners)
# We can simply list the environment to specify the library.
sl = SuperLearner(Y = Y, X = X, SL.library = ls(learners), family = binomial(), env = learners)
sl
}

}

