% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_knn_graph.R
\name{build_knn_graph}
\alias{build_knn_graph}
\title{Build kNN graph}
\usage{
build_knn_graph(
  X,
  k = 5,
  from = c("dist", "coordinates"),
  use.nn2 = TRUE,
  return_neighbors_order = FALSE,
  dist_method = "euclidean",
  cor_method = "pearson",
  p = 2,
  directed = FALSE,
  DoSNN = FALSE,
  which.snn = c("bluster", "dbscan"),
  pruning = NULL,
  kmin = 0,
  ...
)
}
\arguments{
\item{X}{either distance or matrix of coordinates (rows are samples and cols are coordinates)}

\item{k}{kNN parameter}

\item{from}{from which data type to build kNN network: "dist" if X is a distance (dissimilarity) or "coordinates" if X is a matrix with coordinates as cols and cells as rows}

\item{use.nn2}{whether use \link[RANN]{nn2} method to buid kNN network faster (available only for "coordinates" option)}

\item{return_neighbors_order}{whether return order of neighbors (not available for nn2 option)}

\item{dist_method}{method to compute dist (if X is a matrix of coordinates) available: c("cor", "euclidean", "maximum", "manhattan", "canberra", "binary", "minkowski")}

\item{cor_method}{if distance is computed as correlation (dist_method == "cor), which type of correlation to use (available: "pearson", "kendall", "spearman")}

\item{p}{p param in \code{"dist"} function}

\item{directed}{whether to build a directed graph}

\item{DoSNN}{whether to apply shared nearest neighbors (default is \code{FALSE})}

\item{which.snn}{whether to use \link[bluster]{neighborsToSNNGraph} or \link[dbscan]{sNN} for sNN graph construction}

\item{pruning}{quantile to perform edge pruning (default is \code{NULL} - no pruning applied) based on PCA distance distribution}

\item{kmin}{keep at least \code{kmin} edges in single-cell graph when pruning applied (idnored if \code{is.null(pruning)})}

\item{...}{other parameters of \link[bluster]{neighborsToSNNGraph} or \link[dbscan]{sNN}}
}
\value{
a list with components
\itemize{
  \item graph.knn - igraph object
  \item order - Nxk matrix with indices of k nearest neighbors ordered by relevance (from 1st to k-th)
}
}
\description{
Build kNN graph either from distance (from == "dist") or from coordinates (from == "coordinates")
}
