% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuessR_Package.R
\encoding{UTF-8}
\name{SuessR}
\alias{SuessR}
\title{Calculate Suess and Laws corrections for stable carbon isotope data from a built-in region}
\usage{
SuessR(data, correct.to = 1850)
}
\arguments{
\item{data}{A matrix or data frame including columns containing sample ID ('id'), year of sample collection ('year'),
region of sample collection ('region'), and uncorrected \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C
data ('d13c').}

\item{correct.to}{The year to which the \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C data will be corrected. Defaults to 1850 (Industrial Revolution).}
}
\value{
The output of this function is a data frame that includes the sample ID ('id'), year ('year'),
  uncorrected \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C ('d13c.uncor'), Laws correction ('Laws.cor'), Suess Correction ('Suess.cor'), net correction
  ('net.cor'), and corrected \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C ('d13c.cor') for each sample. The corrected \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C data is equal to the uncorrected \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C data
  plus the net correction. The units for all values are the standard 'per mil' used for \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C data.
}
\description{
Generates region-specific Suess, Laws, and net (Suess + Laws) corrections for stable carbon isotope data
  \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C data input by the user. The net correction is then used to calculate the corrected \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C data, which are supplied
  in the output. This function is specifically for data from regions currently built into SuessR
  ("Bering", "Aleutians","Gulf of Alaska", and "Subpolar North Atlantic", as of Version 0.1.2).
  \if{html}{\figure{Built-in-regions.png}{options: width=600 alt="Built-in regions"}}
  \if{latex}{\figure{Built-in-regions.png}{options: width=6in}}
}
\details{
The SuessR() function uses the year and region of sample collection to calculate Suess, Laws, and net (Suess + Laws)
  corrections for \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C data from marine organisms. The Suess Correction represents the change in \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C values of dissolved
  inorganic carbon (DIC) in the surface ocean, and is calculated using an exponential function, calibrated to the global decline
  DIC \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C values. Surface waters in different regions exhibit varying rates of CO\ifelse{html}{\out{<sub>2</sub>}}{\eqn{_2}} uptake from the atmosphere as a result of
  differing water mass properties and residence time at the surface. Thus, a region-specific modifier has been
  calculated from empirical observations of changes in DIC \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C values through time and is applied to each region. The Laws
  correction accounts for changes in stable carbon isotope fractionation during CO\ifelse{html}{\out{<sub>2</sub>}}{\eqn{_2}} uptake and photosynthesis by phytoplankton,
  and is impacted by changes in aqueous CO\ifelse{html}{\out{<sub>2</sub>}}{\eqn{_2}} concentrations, temperature, and salinity, as well as community growth rates,
  average cell diameter, average organic carbon content of phytoplankton cells, permeability of the phytoplankton plasmalemma to CO\ifelse{html}{\out{<sub>2</sub>}}{\eqn{_2}},
  and the ratio of net diffusional loss of CO\ifelse{html}{\out{<sub>2</sub>}}{\eqn{_2}} to carbon fixation. Historic observations and reconstructions of atmospheric CO\ifelse{html}{\out{<sub>2</sub>}}{\eqn{_2}} concentrations,
  sea surface temperature, and sea surface salinity are used to make these calculations. See references for more details.

This function allows users to correct their data to a specific year, using the 'correct.to' argument. This argument defaults
  to AD1850, which represents onset of the Industrial Revolution and the initiation of the large-scale combustion of fossil
  fuels that created the Suess Effect. Correcting data to 1850 allows them to be compared to data from any samples collected during
  or before 1850 (including archaeological samples), as well as to any other samples Suess corrected to the year 1850. Users
  examining contemporary datasets may wish to correct their data to another year. For example, a user examining a dataset
  of \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C data spanning the years 1970-2010 might choose to correct all their data back to the year 1970, to correct the
  older samples forward to 2010, or to correct all the samples to 1990, the middle of the time series. In any of these scenarios,
  corrected data would be comparable to one another. When choosing a value for 'correct.to' consideration should be given to
  the comparability of the user's data to existing data sets, clarity of presentation of results (i.e., clear statements of the
  year to which the data were corrected), and reproducibility of results (i.e., presentation of both uncorrected and corrected
  data so future users can repeat analyses or correct the raw data to another year).
}
\examples{
example.data <- data.frame(id = c("Sample 1", "Sample 2", "Sample 3", "Sample 4",
                                  "Sample 5", "Sample 6", "Sample 7", "Sample 8"),
                           year = c(2017, 2017, 2017, 2017, 1977, 1977, 1977, 1977),
                           d13c = c(-12, -12, -12, -12, -12, -12, -12, -12),
                           region = c("Bering Sea", "Aleutian Islands",
                                      "Gulf of Alaska", "Subpolar North Atlantic",
                                      "Bering Sea", "Aleutian Islands",
                                      "Gulf of Alaska", "Subpolar North Atlantic"))

SuessR(data = example.data)
}
\references{
Clark, C.T., M.R. Cape, M.D. Shapley, F.J. Mueter, B.P. Finney, and N. Misarti. (In Prep) SuessR: Regional Suess
  and Laws corrections for \ifelse{html}{\out{&delta;<sup>13</sup>}}{\eqn{{\delta}^{13}}}C from marine organisms.

Clark, C.T., L. Horstmann, A. de Vernal, A.M. Jensen, and N. Misarti. (2019) Pacific walrus diet across 4000 years of
  changing sea ice conditions. \emph{Quaternary Research}, 1-17.

Misarti, N., B. Finney, H. Maschner, and M.J. Wooller. (2009) Changes in northeast Pacific marine ecosystems over the last 4500
  years: evidence from stable isotope analysis of bone collagen from archaeological middens. \emph{The Holocene}, 19:8. 1139-1151.
}
