% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetSubTite.R
\name{GetSubTite}
\alias{GetSubTite}
\title{Gives the subgroup specific optimal dose vector.}
\usage{
GetSubTite(Y, I, Doses, Groups, Hyper, T1, Target, Dose, Upper, DoseTried)
}
\arguments{
\item{Y}{Vector containing observed event or censoring times.}

\item{I}{Vector containing event indicators (1 if patient experiences an event for a patient).}

\item{Doses}{Vector containing Doses of patients in trial.}

\item{Groups}{Vector containing group assignment of patients, 1 is baseline group.}

\item{Hyper}{List of size 4 containing, in order, the prior mean of the baseline slope, the baseline intercept, and the prior mean vectors for group specific intercepts and slopes.}

\item{T1}{Reference time for toxicity.}

\item{Target}{Target cumulative toxicity probability vector at time T1.}

\item{Dose}{Vector containing the standardized doses considered.}

\item{Upper}{Cutoff values used to determine if accrual in a subgroup should be suspended.}

\item{DoseTried}{#Groups X #Doses Matrix that contains 1s and 0s corresponding to whether a given dose in a subgroup had been tried.}
}
\value{
Returns a list with two objects, a vector of optimal doses and a vector of stopped groups
}
\description{
Returns a list containing the optimal doses to enroll each subgroup at and the subgroups that should have their accrual suspended temporarily.
}
\examples{
set.seed(1)
##Specify reference toxicity time and target
T1=6
Target=.3
##Number of Groups
##Specify upper bound for determining if the lowest dose is too toxic in a subgroup
Upper=c(.9,.95,.95)
##Randomly generate data for use.
n=60
Y=runif(n,0,100)
I=rbinom(n,1,.5)
Y[I==0]=T1
Groups = sample(1:3,n,replace=TRUE)
Doses = sample(1:5,n,replace=TRUE)
Dose = rnorm(5)
##Doses Tried so far in trial
DoseTried=matrix(c(1,1,0,0,0,1,1,1,1,1,1,1,0,0,0),ncol=5,byrow=TRUE)
##What Groups are currently stopped
##Hypermeans for linear terms
meanmu=2.21
meanslope=-.57
MeanInts = c(.46, .55)
MeanSlopes = c(.04,.10)
##Fill in Hyperparameter list for MCMC
Hyper=as.list(c(0,0,0,0))
Hyper[[1]]=meanmu
Hyper[[2]]=meanslope
Hyper[[3]]=MeanInts
Hyper[[4]]=MeanSlopes
GetSubTite(Y,I,Doses,Groups,Hyper,T1,Target,Dose,Upper,DoseTried)
}
\references{
[1] Chapple and Thall (2017), Subgroup-specific Dose Finding in Phase I Clinical Trials Based on Time to Toxicity.
}
