% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reposition.R
\name{reposition}
\alias{reposition}
\title{Core correction}
\usage{
reposition(dec, inc, cdec = 0, cinc = 90, crot = 0)
}
\arguments{
\item{dec}{declination of the data; it is the angle from the north
taken on an horizontal plane. It is measured clockwise from North and ranges
from 0 to 360° (Tauxe 2010).}

\item{inc}{inclination of the data; it is the angle from the
horizontal, is positive downward, and ranges from +90° for straight down to
-90° for straight up (Tauxe, 2010).}

\item{cdec}{declination of the core.}

\item{cinc}{inclination of the core.}

\item{crot}{rotation of the core; it is the angle of rotation around
the core direction clockwise between the measurement and the actual core
orientation. In others words it is the magnitude of the rotation to apply
clockwise to the measured data using the core direction as an axis.}
}
\description{
Core correction : declination and inclination are corrected for
cores of given declination, inclination and rotation
}
\examples{
# ----

d <- zeq_example

dec <- d$Dec
inc <- d$Inc

cdec <- 75
cinc <- 45
crot <- 90

par(mfrow = c(2,2))

earnet()
earpoints(dec,inc)
earpoints(0, 90, l = list(cex = 2))
earpoints(0, 90, l = list(col = "red", bg = "red"))
title("1. Laboratory projection,
      axis for rotating the specimen")

# Roll ----

roll <- reposition(dec, inc, crot = 90)

earnet()
earpoints(roll$dec,roll$inc)
earpoints(0, 90, l = list(cex = 2))
earpoints(90, 0, h = list(col = "red", bg = "pink"), double = TRUE)
title("2. Correction of the specimen rotation,
      in red the axis for tilting the specimen")

# Tilt ---

tilt <- reposition(dec, inc, cinc = cinc ,crot = crot)

earnet()
earpoints(0, cinc, l = list(cex = 2))
earpoints(tilt$dec, tilt$inc)
earpoints(0,90, l = list(col = "red", bg = "red"))
title("3. Correction of the specimen inclination,
      in red the axis for rotating the tilted specimen")

# Orient ---

orient <- reposition(dec, inc, cdec = cdec, cinc = cinc ,crot = crot)

earnet()
earpoints(cdec, cinc, l = list(cex = 2))
earpoints(orient$dec, orient$inc)
title("4. Full geographical repositioning,
      the big dot is the core orientation")

par(mfrow = c(1,1))

# ----

}
\seealso{
\code{\link{rotate}} and \code{\link{restore}}
}
