% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divisor.R
\name{divisor}
\alias{divisor}
\alias{is.divisor}
\title{Greatest Common Rational Divisor}
\usage{
divisor(x, tolerance = 8, relative = T, tries = 4, speak = T)

is.divisor(x, y, tolerance = 8, relative = T, use.names = T)
}
\arguments{
\item{x}{a numeric or integer vector}

\item{tolerance}{the order of tolerance for errors, i.e. the number of
decimals considered as being meaningful}

\item{relative}{whether to apply the tolerance to the x values divided by
the smallest x value (TRUE, is the default), or to the x values themselves}

\item{tries}{the amount of iterations: each iteration tests 10^n+1 more
possibilities than the previous one. This is to optimise computation while
allowing all possibilities to be explored. Each try takes exponentialy more
time than the previous one}

\item{speak}{whether to print a sentence at each try}

\item{y}{a numeric or integer vector of vales to be tested as divisors of x}

\item{use.names}{whether to use y values as names for the output}
}
\description{
Compute the Greatest Common Rational Divisor or test whether
a value is a common rational divisor of a suite of number
}
\examples{
divisor(x = c(0.03,0.75,0.3,2,100, 0.03, 100, 0), speak = FALSE)

divisor(x = c(0.02,0.75,0.3,2,100.000002, 0.03, 100, 0), speak = FALSE)

divisor(x = c(0.02,0.75,0.3,2,100.000002, 0.03, 100, 0) * 10^-10,
        speak = FALSE)


a <- c(0.02,0.75,0.3,2,100.000000002, 0.03, 100, 0)

divisor(x = a)

is.divisor(x = a, y = c(1, 0.01, 2*10^-9))

divisor(x = a, tolerance = 7, speak = FALSE)

divisor(x = a, relative = FALSE, speak = FALSE)

}
