% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ylink.R
\name{ylink}
\alias{ylink}
\title{Draws connection lines to connect two points in y}
\usage{
ylink(y1, y2, x1, x2, ratio = 0.1, xi1 = NA, xi2 = NA, l = list(lty =
  3))
}
\arguments{
\item{y1, y2}{y positions (you can provide several ones at once)}

\item{x1, x2}{x positions (you can provide several ones at once)}

\item{ratio}{the ratio of the breaking points of the lines (from the
start or end to the centre)}

\item{xi1, xi2}{x positions of the
breaking points of the lines.}

\item{l}{a list of arguments to feed lines(). Go see ?lines to know
which arguments can be provided. See ?merge.list for further information.}
}
\description{
Draws connection lines to connect two points in y
}
\examples{
plot(c(0,6),c(-20,20), type = "n")

infobar(ymin = c(-20,0), ymax = c(0,20), xmin = 1, xmax = 0,
        m = list(col = c("black", "white")))

infobar(ymin = c(-20,10), ymax = c(10,20), xmin = 5, xmax = 6,
        m = list(col = c("black", "white")))

ylink(c(0,12),c(10,20), x1 = 1, x2 = 5, ratio = 0.2,
      l = list(lty = c(1,3), lwd = 2))

}
\seealso{
\code{\link{multilines}}, \code{\link{bedtext}} and
\code{\link{infobar}}
}
