% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findB.R
\name{findB}
\alias{findB}
\title{Find best sub-matrix B in stratifiedcube}
\usage{
findB(X, strata)
}
\arguments{
\item{X}{A matrix of size (\eqn{N} x \eqn{p}) of auxiliary variables on which the sample must be balanced.}

\item{strata}{A vector of integers that specifies the stratification.}
}
\value{
A list of two components. The sub-matrix of \code{X} and the corresponding disjunctive matrix.
 If we use the function \code{cbind} to combine the two matrices, the resulting matrix has only one more row than the number of columns.
}
\description{
This function is computing a sub-matrix used in \code{\link{stratifiedcube}}.
}
\details{
The function finds the smallest matrix B such that it contains only one more row than the number of columns.
It consecutively adds the right number of rows depending on the number of categories that is added.
}
\examples{
N <- 1000
strata <-  sample(x = 1:6, size = N, replace = TRUE)

p <- 3
X <- matrix(rnorm(N*p),ncol = 3)
findB(X,strata)

}
\author{
Raphaël Jauslin \email{raphael.jauslin@unine.ch}
}
