% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBehaviour.R
\name{plotBehaviour}
\alias{plotBehaviour}
\title{Plotting spatial wind behaviour}
\usage{
plotBehaviour(
  sts,
  rasterProduct,
  colorPalette = NULL,
  main = NULL,
  xlim = NULL,
  ylim = NULL,
  labels = FALSE,
  by = 8,
  pos = 3,
  legends = "topleft"
)
}
\arguments{
\item{sts}{\code{StormsList} object.}

\item{rasterProduct}{layer name in a \code{SpatRaster} object. The names of the layers follow
the following terminology:
\itemize{
\item for "MSW" or "PDI", the name of the storm in capital letters and the name of the
statistic separated by underscores (e.g., "PAM_MSW", "PAM_PDI"),
\item for duration of exposure, the name of the storm in capital letters, "Exposure",
and the threshold value separated by underscores (e.g., "PAM_Exposure_18", "PAM_Exposure_33", ...).
\item for wind profiles, the name of the storm in capital letters, "Speed" or "Direction",
and the indices of the observation separated by underscores (e.g., "PAM_Speed_41", "PAM_Direction_41",...).
}}

\item{colorPalette}{character vector. The color palette used to plot the raster layer.
If \code{colorPalette=NULL} (default setting), the default color palette is used.}

\item{main}{character. Title of the plot. If \code{main=NULL} (default setting),
a default title is generated based on the name of the layer.}

\item{xlim}{numeric vector. The x limits of the plot.}

\item{ylim}{numeric vector. The y limits of the plot.}

\item{labels}{logical. Whether (TRUE) or not (FALSE, default setting) to add labels with the name
of the storm and the indices and ISO times of the observation.}

\item{by}{numeric. If \code{labels=TRUE}, defines the frequency at which labels are plotted.
Default value is set to \code{8} which corresponds to a 24h (or 48h) time interval between the labelled observations
when observations are made every 3 (or 6) hours.}

\item{pos}{numeric. If \code{labels=TRUE}, defines the position of the labels, \code{1} (above the observation),
\code{2} (on the left), \code{3} (below, default setting), and \code{4} (on the right).}

\item{legends}{character. Indicates where to plot the legend, \code{"topright"}, \code{"topleft"} (default setting),
\code{"bottomleft"}, \code{"bottomright"}, or \code{"none"} (legend not plotted).}
}
\value{
A plot of the storm track data with the raster layer.
}
\description{
The \code{plotBehaviour()} function allows plotting spatial statistics generated using
the \code{spatialBehaviour()} function and stored in \code{SpatRaster} objects.
}
\examples{
\donttest{
# Creating a stormsDataset
sds <- defStormsDataset()

# Getting storm track data for tropical cyclone Pam (2015)
pam <- defStormsList(sds = sds, loi = "Vanuatu", names = "PAM")

# Plotting maximum sustained wind speed for Pam (2015) near Vanuatu
pam.msw <- spatialBehaviour(pam, verbose = 0)
plotBehaviour(pam, pam.msw)

# Plotting 2D wind speed profile for Pam (2015) near Vanuatu
pam.prof <- spatialBehaviour(pam, product = "Profiles", verbose = 0)
plotBehaviour(pam, pam.prof$PAM_Speed_37, labels = TRUE, pos = 4)
}
}
