% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_out_var.R
\name{get_var_info}
\alias{get_var_info}
\title{Find STICS output variable names and description}
\usage{
get_var_info(
  var = NULL,
  keyword = NULL,
  stics_version = "latest",
  version = lifecycle::deprecated()
)
}
\arguments{
\item{var}{Vector of variable names (or partial names).
Optional, if not provided, the function returns information for
all variables.}

\item{keyword}{Search by keyword instead of variable name
(search in the name and description field)}

\item{stics_version}{Name of the STICS version. Optional, can be used
to search parameters information relative to a specific STICS version.
By default the latest version returned by \code{get_stics_versions_compat()}
is used.}

\item{version}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{version} is no
longer supported, use \code{stics_version} instead.}
}
\value{
A data.frame with information about variable(s) with columns
\code{name}, \code{definition}, \code{unit}, \code{type}
}
\description{
Helper function that returns names and descriptions of
STICS output variables from a partial name and/or descriptive keywords.
}
\details{
The function understand \code{\link[base]{regex}} as input.
}
\examples{

# Find by variable name (fuzzy search):
SticsRFiles::get_var_info("lai")

# Find by keyword (fuzzy search in variable name and description):
SticsRFiles::get_var_info(keyword = "lai")

# Find for a particular version:
SticsRFiles::get_var_info("lai", stics_version = "V9.0")


}
