% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_prop.test.R
\name{p_prop.test}
\alias{p_prop.test}
\alias{gen_prop.test}
\title{p-value from proportion test simulation}
\usage{
p_prop.test(
  n,
  h,
  prop = NULL,
  pi = 0.5,
  n.ratios = rep(1, length(prop)),
  two.tailed = TRUE,
  correct = TRUE,
  exact = FALSE,
  gen_fun = gen_prop.test,
  ...
)

gen_prop.test(
  n,
  h,
  prop = NULL,
  pi = 0.5,
  n.ratios = rep(1, length(prop)),
  ...
)
}
\arguments{
\item{n}{sample size per group}

\item{h}{Cohen's h effect size; only supported for one-sample analysis.

Note that it's important to specify the null
value \code{pi} when supplying this effect size as the power
changes depending on these specific values (see example below).}

\item{prop}{sample probability/proportions of success.
If a vector with two-values or more elements are supplied then
a multi-samples test will be used. Matrices are also supported}

\item{pi}{probability of success to test against (default is .5). Ignored
for two-sample tests}

\item{n.ratios}{allocation ratios reflecting the sample size ratios.
Default of 1 sets the groups to be the same size (n * n.ratio)}

\item{two.tailed}{logical; should a two-tailed or one-tailed test be used?}

\item{correct}{logical; use Yates' continuity correction?}

\item{exact}{logical; use fisher's exact test via \code{\link{fisher.test}}?
Use of this flag requires that \code{prop} was specified as a matrix}

\item{gen_fun}{function used to generate the required discrete data.
Object returned must be a \code{matrix} with two rows and 1 or more
columns. Default uses \code{\link{gen_prop.test}}.
User defined version of this function must include the argument \code{...}}

\item{...}{additional arguments to be passed to \code{gen_fun}. Not used
unless a customized \code{gen_fun} is defined}
}
\value{
a single p-value
}
\description{
Generates single and multi-sample data
for proportion tests and return a p-value. Uses \code{\link{binom.test}}
for one-sample applications and \code{\link{prop.test}} otherwise.
}
\examples{

# one sample, 50 observations, tested against pi = .5 by default
p_prop.test(50, prop=.65)

# specified using h and pi
h <- pwr::ES.h(.65, .4)
p_prop.test(50, h=h, pi=.4)
p_prop.test(50, h=-h, pi=.65)

# two-sample test
p_prop.test(50, prop=c(.5, .65))

# two-sample test, unequal ns
p_prop.test(50, prop=c(.5, .65), n.ratios = c(1,2))

# three-sample test, group2 twice as large as others
p_prop.test(50, prop=c(.5, .65, .7), n.ratios=c(1,2,1))

# Fisher exact test
p_prop.test(50, prop=matrix(c(.5, .65, .7, .5), 2, 2))

\donttest{
    # compare simulated results to pwr package

    # one-sample tests
    (h <- pwr::ES.h(0.5, 0.4))
    pwr::pwr.p.test(h=h, n=60)

    # uses binom.test (need to specify null location as this matters!)
    Spower(p_prop.test(n=60, h=h, pi=.4))
    Spower(p_prop.test(n=60, prop=.5, pi=.4))

    # compare with switched null
    Spower(p_prop.test(n=60, h=h, pi=.5))
    Spower(p_prop.test(n=60, prop=.4, pi=.5))

    # two-sample test, one-tailed
    (h <- pwr::ES.h(0.67, 0.5))
    pwr::pwr.2p.test(h=h, n=80, alternative="greater")
    p_prop.test(n=80, prop=c(.67, .5), two.tailed=FALSE,
      correct=FALSE) |> Spower()

    # same as above, but with continuity correction (default)
    p_prop.test(n=80, prop=c(.67, .5), two.tailed=FALSE) |>
      Spower()

    # three-sample joint test, equal n's
    p_prop.test(n=50, prop=c(.6,.4,.7)) |> Spower()

}

}
\seealso{
\code{\link{gen_prop.test}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
