#' Net spillovers
#' 
#'@description
#' Computes the net spillover index.
#' 
#'@param x Object of class \sQuote{\code{spillover.table}} generated by either \code{O.spillover()} or  \code{G.spillover()}.
#'@return A list length \emph{K} holding the generalized forecast error variances as matrices.
#'
#'@references 
#'Pesaran, M. H. and Shin, Y. (1998). \emph{Generalized impulse response analysis in linear multivariate models}. Economics Letters, 58(1):17-29.
#'@author Jilber Urbina
#'@seealso \code{\link{O.spillover}} \code{\link{G.spillover}}
#'@export



net <- function(x){
  .Deprecated("dynamic.spillover")
  TO   <- x[nrow(x)-1, 1:ncol(x)-1]
  FROM <- x[1:(nrow(x)-2), ncol(x)]
  NET <- TO - FROM
  data.frame(To=TO, From=FROM, Net=NET, Transmitter=NET>0)
}

# 
# data(rol.returns)
# model <- VAR(rol.returns)
# x <- G.spillover(model)
# Spillovers::G.spillover(model)

