% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_location.R
\name{grid_location}
\alias{grid_location}
\title{Grid the locations with fixed cell size}
\usage{
grid_location(
  lon,
  lat,
  sp.resolution = 2,
  lon.range = range(lon),
  lat.range = range(lat)
)
}
\arguments{
\item{lon}{Numeric, \code{n} longitude values}

\item{lat}{Numeric, \code{n} latitude values}

\item{sp.resolution}{Numeric, must be a single value that indicates the minimal unit length of
a grid cell.}

\item{lon.range}{Optional vector that indicates the range of \code{lon}. Default is \code{range(lon)}.}

\item{lat.range}{Optional vector that indicates the range of \code{lat}. Default is \code{range(lat)}.}
}
\value{
An \verb{n x 3} data frame containing three variables: \code{cell_ind} corresponds to unique id
for each grid cell,
\code{cell_lon} is the longitude of the grid cell, \code{cell_lat} is the latitude of the grid cell.
Since the output data frame retains the order of the input coordinates, the original coordinate
dataset and the output have can be linked one-to-one by the row index.
}
\description{
Grid the locations with fixed cell size
}
\details{
The longitude and latitude of each grid cell are the coordinate of the cell center.
For example, if \code{sp.resolution=1}, then \code{cell_lon=55.5} and \code{cell_lat=22.5} correspond to the
square whose left boundary is 55, right boundary is 56, upper boundary is 23, and lower boundary
is 22.
}
\examples{
longitude <- runif(20, -90, 80)
latitude <- runif(20, 40, 60)
grid_locs <- grid_location(longitude, latitude, sp.resolution=0.5)
cbind(longitude, latitude, grid_locs)
}
