\name{map}
\alias{map}
\title{Produces a 2D map from a fitted max-stable process}
\description{
  Produces a 2D map from a fitted max-stable process.
}
\usage{
map(fitted, x, y, covariates = NULL, param = "quant", ret.per = 100, col
= terrain.colors(64), plot.contour = TRUE, \dots)
}
\arguments{
  \item{fitted}{An object of class \code{maxstab}. Most often, it will
    be the output of the function \code{\link{fitmaxstab}}.}
  \item{x,y}{Numeric vector that gives the coordinates of the grid.}
  \item{covariates}{An array specifying the covariates at each grid
    point defined by \code{x} and \code{y}. If \code{NULL}, no covariate
    is needed. See the example to see how to build it.}
  \item{param}{A character string. Must be one of "loc", "scale",
    "shape" or "quant" for a map of the location, scale, shape
    parameters or for a map of a specified quantile.}
  \item{ret.per}{A numeric giving the return period for which the
    quantile map is plotted. It is only required if \code{param =
      "quant"}.}
  \item{col}{A list of colors such as that generated by 'rainbow',
    'heat.colors', 'topo.colors', 'terrain.colors' or similar
    functions.}
  \item{plot.contour}{Logical. If \code{TRUE} (default), contour lines
    are added to the plot.}
  \item{\dots}{Several arguments to be passed to the \code{link{image}}
    function.}
}
\value{
  A plot. Additionally, a list with the details for plotting the map is
  returned invisibly.
}
\seealso{
  \code{\link{condmap}}, \code{\link{filled.contour}},
  \code{\link{heatmap}}, \code{\link{heat.colors}},
  \code{\link{topo.colors}}, \code{\link{terrain.colors}},
  \code{\link{rainbow}}
}
\examples{
##We run an artifical example using the volcano data set as a study
##region
dim <- dim(volcano)
n.x <- dim[1]
n.y <- dim[2]

x <- 10 * 1:n.x
y <- 10 * 1:n.y

n.site <- 15
idx.x <- sample(n.x, n.site)
idx.y <- sample(n.y, n.site)
locations <- cbind(lon = x[idx.x], lat = y[idx.y])
alt <- diag(volcano[idx.x, idx.y])

##Simulate a max-stable process - with unit Frechet margins
data <- rmaxstab(40, locations, cov.mod = "whitmat", sill = 1, range = 750,
smooth = 1)

##Now define the spatial model for the GEV parameters
param.loc <- -10 - 0.04 * locations[,1] + alt / 5
param.scale <- 5 - locations[,2] / 30 + alt / 4
param.shape <- rep(.2, n.site)

##Transform the unit Frechet margins to GEV 
for (i in 1:n.site)
  data[,i] <- frech2gev(data[,i], param.loc[i], param.scale[i],
param.shape[i])

##Define a model for the GEV margins to be fitted
##shape ~ 1 stands for the GEV shape parameter is constant
##over the region
loc.form <- loc ~ lon + alt
scale.form <- scale ~ lat + alt
shape.form <- shape ~ 1

##  1- Fit a max-stable process
schlather <- fitmaxstab(data, locations, "whitmat", loc.form, scale.form,
                        shape.form, marg.cov = cbind(alt = alt), sill =
1, std.err.type = "none")

##  2- Produce a map of the pointwise 50-year return level

##Here we have only one covariate i.e. alt
n.cov <- 1 
covariates <- array(volcano, dim = c(n.x, n.y, n.cov), dimnames =
list(NULL, NULL, "alt"))

par(mfrow = c(1,2))
image(x, y, volcano, col = terrain.colors(64), main = "Elevation map")
map(schlather, x, y, covariates, ret.per = 50, plot.contour = FALSE,
main = "50-year return level")
}
\author{Mathieu Ribatet}
\keyword{hplot}
