% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routines.R
\name{checkident}
\alias{checkident}
\title{Check a model for the existence and identifiability of the maximum likelihood estimate}
\usage{
checkident(zdat, mX = 0, verbose = F)
}
\arguments{
\item{zdat}{Data matrix with \eqn{t+1} columns. The first \eqn{t} columns, each corresponding to a particular list,
are 0s and 1s defining the capture histories
observed. The last column is the count of cases with that particular capture history.
List names A, B, ... are constructed if not supplied. Where a capture history is not explicitly listed,
it is assumed that it has observed count zero.}

\item{mX}{A \eqn{2 \times k} matrix giving the \eqn{k} two-list interactions to be included in the model.
Each column of \code{mX} contains the numbers of the corresponding pair of lists.
If \code{mX = 0}, then all two-list interactions are included. If \code{mX = NULL}, no interactions are included and
 the main effects model is fitted.}

\item{verbose}{Specifies the output.   If \code{F} then the error code is returned.  If \code{T} then
in addition the routine prints an error message if the model/data fail either of the two tests, and also
returns both the error code and the \code{lp} object.}
}
\value{
If \code{verbose=F}, then return the error code \code{ierr} which is 1 if the linear program test shows that the maximum likelihood
 estimate does not exist, 2 if it is not identifiable, and 3 if both tests are failed.

If \code{verbose=T}, then return a list with components as below

\code{ierr} As described above.

\code{zlp} Linear programming object, in particular giving the value of the objective function at optimum.
}
\description{
Apply the linear programming test as derived by Fienberg and Rinaldo (2012), and a calculation of the rank of the design
matrix, to check whether a particular model yields an identifiable maximum likelihood estimate
based on the given data.  The particular algorithm applied is described on page 3 of the supplementary material, with a typographical error corrected.
}
\references{
Fienberg, S. E. and Rinaldo, A. (2012). Maximum likelihood estimation in log-linear
models. Ann. Statist. 40, 996-1023.  Supplementary material: Technical report, Carnegie Mellon University. Available from \url{http://www.stat.cmu.edu/~arinaldo/Fienberg_Rinaldo_Supplementary_Material.pdf}.
}
