% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkpoint.R, R/simList-accessors.R
\docType{methods}
\name{doEvent.checkpoint}
\alias{.checkpointSave}
\alias{checkpointFile}
\alias{checkpointFile,.simList-method}
\alias{checkpointFile<-}
\alias{checkpointFile<-,.simList-method}
\alias{checkpointInterval}
\alias{checkpointInterval,.simList-method}
\alias{checkpointInterval<-}
\alias{checkpointInterval<-,.simList-method}
\alias{checkpointLoad}
\alias{doEvent.checkpoint}
\title{Simulation checkpoints.}
\usage{
doEvent.checkpoint(sim, eventTime, eventType, debug = FALSE)

checkpointLoad(file)

.checkpointSave(sim, file)

checkpointFile(object)

\S4method{checkpointFile}{.simList}(object)

checkpointFile(object) <- value

\S4method{checkpointFile}{.simList}(object) <- value

checkpointInterval(object)

\S4method{checkpointInterval}{.simList}(object)

checkpointInterval(object) <- value

\S4method{checkpointInterval}{.simList}(object) <- value
}
\arguments{
\item{sim}{A \code{simList} simulation object.}

\item{eventTime}{A numeric specifying the time of the next event.}

\item{eventType}{A character string specifying the type of event: one of
either \code{"init"}, \code{"load"}, or \code{"save"}.}

\item{debug}{Optional logical flag determines whether sim debug info
will be printed (default \code{debug = FALSE}).}

\item{file}{The checkpoint file.}

\item{object}{A \code{simList} simulation object.}

\item{value}{The object to be stored at the slot.}
}
\value{
Returns the modified \code{simList} object.
}
\description{
Save and reload the current state of the simulation,
including the state of the random number generator,
by scheduling checkpoint events.
}
\details{
\code{\link{checkpointLoad}} and \code{\link{.checkpointSave}} code based on:
\url{https://raw.githubusercontent.com/achubaty/r-tools/master/checkpoint.R}

RNG save code adapted from:
\url{http://www.cookbook-r.com/Numbers/Saving_the_state_of_the_random_number_generator/}
and \url{https://stackoverflow.com/questions/13997444/}
}
\author{
Alex Chubaty
}
\seealso{
\code{\link{.Random.seed}}.

Other functions to access elements of a \code{simList} object: \code{\link{.addDepends}},
  \code{\link{envir}}, \code{\link{events}},
  \code{\link{globals}}, \code{\link{inputs}},
  \code{\link{ls.simList}}, \code{\link{ls.str.simList}},
  \code{\link{modules}}, \code{\link{objs}},
  \code{\link{packages}}, \code{\link{params}},
  \code{\link{paths}}, \code{\link{progressInterval}},
  \code{\link{times}}
}

