% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_SpaCCI.R
\name{run_SpaCCI}
\alias{run_SpaCCI}
\title{Run SpaCCI Analysis}
\usage{
run_SpaCCI(
  gene_spot_expression_dataframe,
  spot_cell_proportion_dataframe,
  spatial_coordinates_dataframe,
  LR_database_list,
  specific_LR_pair = NULL,
  analysis_scale,
  region_spot_IDs = NULL,
  local_scale_proportion = 1,
  neighborhood_radius = 2.5
)
}
\arguments{
\item{gene_spot_expression_dataframe}{A data frame of gene expression values, where row names are genes and column names are spot IDs.}

\item{spot_cell_proportion_dataframe}{A data frame of cell type proportions, where row names are spot IDs and column names are cell types.}

\item{spatial_coordinates_dataframe}{A data frame containing the spatial coordinates of the spots. The columns should include \code{"Spot_ID"}, \code{"imagerow"}, and \code{"imagecol"}. And the row names must be the names of \code{"Spot_ID"}.}

\item{LR_database_list}{A list containing ligand-receptor pairs and additional information, generated by functions using \code{`LR_database()`}.}

\item{specific_LR_pair}{Required if \code{analysis_scale} is \code{"local"}. A vector of ligand-receptor pair names for localized analysis. The names should match those in row names in \code{`LR_database_list$possible_LR_pairs_info`}.}

\item{analysis_scale}{A string specifying the scale of analysis: \code{"global"}, \code{"regional"}, or \code{"local"}.}

\item{region_spot_IDs}{Required if \code{analysis_scale} is "regional". A vector of spot IDs defining the region for regional analysis.}

\item{local_scale_proportion}{Optional. A numeric value ranging from 0 to 1, (0,1] specifying the proportion of spots to use for localized analysis. Default is \code{1}, meaning using \code{100}\% proportion of spots. One could modified if want to reducing computing time.}

\item{neighborhood_radius}{Optional. A numeric value specifying the radius of the neighborhood for localized analysis. Default is \code{2.5}, according to the 10X Visium ST data accounting for 200-250 \eqn{\mu}m interacting distance.}
}
\value{
A list containing:
\describe{
  \item{If \code{analysis_scale} is \code{"local"}:}{
    A list containing:
    \describe{
      \item{\code{dataframelist}}{A list of data frames, each representing the inferred interactions for a specific center spot. Each data frame includes information on ligand and receptor cell types, P-values, and adjusted P-values.}
      \item{\code{RegionIDs_matrix}}{A list of matrices, each containing the IDs of the spots within the specified radius of each center spot.}
    }
  }
  \item{If \code{analysis_scale} is \code{"regional"} or \code{"global"}:}{
    A list containing:
    \describe{
      \item{\code{pvalue_df}}{A data frame of inferred interactions within the specified region or globally, including information on ligand and receptor cell types, P-values, and adjusted P-values.}
    }
  }
}
}
\description{
This function runs the SpaCCI analysis to infer cell-cell interactions based on ligand-receptor pairs at global, regional, or local spatial scales. It integrates gene expression data, cell type proportions, and spatial coordinates with a user-specified ligand-receptor database.
}
\details{
The function supports three scales of analysis:
\describe{
  \item{\code{global}}{Analyzes interactions across the entire dataset.}
  \item{\code{regional}}{Analyzes interactions within a specified region of spots. Requires \code{region_spot_IDs}.}
  \item{\code{local}}{Analyzes localized hotspot of interactions for specific ligand-receptor pairs on the entire slides. Requires \code{specific_LR_pair}.}
}
}
\examples{
library(SpaCCI)
library(nnls)
#Load the example data
data(test_data)
gene_spot_df <- test_data$gene_spot_df
cell_prop_df <- test_data$cell_prop_df
spatial_coords_df <- test_data$spatial_coords_df

result <- LR_database(species = "Human",
                      database_name = "CellChat",
                      gene_spot_expression_dataframe = gene_spot_df)
# global
result_global <- run_SpaCCI(gene_spot_expression_dataframe = gene_spot_df,
                            spot_cell_proportion_dataframe = cell_prop_df,
                            spatial_coordinates_dataframe = spatial_coords_df,
                            LR_database_list = result,
                            analysis_scale = "global")

# local
result_local <- run_SpaCCI(gene_spot_expression_dataframe = gene_spot_df,
                          spot_cell_proportion_dataframe = cell_prop_df,
                          spatial_coordinates_dataframe = spatial_coords_df,
                          LR_database_list = result,
                          specific_LR_pair = "EDN2_EDNRA",
                          analysis_scale = "local",
                          local_scale_proportion = 0.1,
                          neighborhood_radius = 2.5)

}
