% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{SpaCCI_region}
\alias{SpaCCI_region}
\title{Infer Cell-Cell Interactions in a Specified Region}
\usage{
SpaCCI_region(
  gene_spot_df,
  spot_cell_prop_df,
  region_spot_IDs,
  matching_L_R_pairs,
  matching_L_R_pairs_info
)
}
\arguments{
\item{gene_spot_df}{A data frame where the rows are genes and the columns are spots (Spot_IDs), representing gene expression levels across spatial spots.}

\item{spot_cell_prop_df}{A data frame of cell type proportions for each spot. The rows represent spots (Spot_IDs), and the columns represent different cell types.}

\item{region_spot_IDs}{A vector of Spot_IDs representing the spots included in the region of interest.}

\item{matching_L_R_pairs}{A data frame containing matching ligand-receptor pairs. Each row corresponds to a ligand-receptor pair, with columns for \code{ligand_vector} and \code{receptor_vector}.}

\item{matching_L_R_pairs_info}{A data frame providing additional information for each ligand-receptor pair, such as pathway information.}
}
\value{
A list containing:
\describe{
  \item{pvalue_df}{A data frame of inferred interactions within the specified region, including information on ligand and receptor cell types, P-values, and adjusted P-values.}
}
}
\description{
This function infers cell-cell interactions within a specified region using spatial transcriptomics data. It applies permutation testing to identify significant ligand-receptor interactions in the region.
}
