% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setProperties.R
\name{setSoupProfile}
\alias{setSoupProfile}
\title{Set soup profile}
\usage{
setSoupProfile(sc, soupProfile)
}
\arguments{
\item{sc}{A SoupChannel object.}

\item{soupProfile}{A data.frame with columns \code{est} containing the fraction of soup for each gene, \code{counts} containing the total counts for each gene and with row names corresponding to the row names of \code{sc$toc}.}
}
\value{
An updated SoupChannel object with the soup profile set.
}
\description{
Manually sets or updates the soup profile for a SoupChannel object.
}
\examples{
#Suppose only table of counts is available
toc = Seurat::Read10X(system.file('extdata','toyData','filtered_gene_bc_matrices','GRCh38',
                                  package='SoupX'))
#Suppress calculating soup profile automatically
sc = SoupChannel(toc,toc,calcSoupProfile=FALSE)
#And add manually
rowSums = Matrix::rowSums
soupProf = data.frame(row.names = rownames(toc),est=rowSums(toc)/sum(toc),counts=rowSums(toc))
sc = setSoupProfile(sc,soupProf)
}
