% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load10X.R
\name{load10X}
\alias{load10X}
\title{Load a collection of 10X data-sets}
\usage{
load10X(
  dataDir,
  cellIDs = NULL,
  channelName = NULL,
  readArgs = list(),
  includeFeatures = c("Gene Expression"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{dataDir}{Top level cellranger output directory (the directory that contains the \code{raw_gene_bc_matrices} folder).}

\item{cellIDs}{Barcodes of droplets that contain cells.  If NULL, use the default cellranger set.}

\item{channelName}{The name of the channel to store.  If NULL set to either \code{names(dataDir)} or \code{dataDir} is no name is set.}

\item{readArgs}{A list of extra parameters passed to \code{Seurat::Read10X}.}

\item{includeFeatures}{If multiple feature types are present, keep only the types mentioned here and collapse to a single matrix.}

\item{verbose}{Be verbose?}

\item{...}{Extra parameters passed to \code{SoupChannel} construction function.}
}
\value{
A SoupChannel object containing the count tables for the 10X dataset.
}
\description{
Loads unfiltered 10X data from each data-set and identifies which droplets are cells using the cellranger defaults.
}
\examples{
sc = load10X(system.file('extdata','toyData',package='SoupX'))
}
\seealso{
SoupChannel estimateSoup
}
