% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoftBart.R
\name{Opts}
\alias{Opts}
\title{MCMC options for SoftBart}
\usage{
Opts(
  num_burn = 2500,
  num_thin = 1,
  num_save = 2500,
  num_print = 100,
  update_sigma_mu = TRUE,
  update_s = TRUE,
  update_alpha = TRUE,
  update_beta = FALSE,
  update_gamma = FALSE,
  update_tau = TRUE,
  update_tau_mean = FALSE,
  update_sigma = TRUE,
  cache_trees = TRUE
)
}
\arguments{
\item{num_burn}{Number of warmup iterations for the chain.}

\item{num_thin}{Thinning interval for the chain.}

\item{num_save}{The number of samples to collect; in total, \code{num_burn + num_save * num_thin} iterations are run.}

\item{num_print}{Interval for how often to print the chain's progress.}

\item{update_sigma_mu}{If \code{TRUE}, \code{sigma_mu} is  updated, with a half-Cauchy prior on \code{sigma_mu} centered at the initial guess.}

\item{update_s}{If \code{TRUE}, \code{s} is updated using the Dirichlet prior \eqn{s \sim D(\alpha / P, \ldots, \alpha / P)} where \eqn{P} is the number of covariates.}

\item{update_alpha}{If \code{TRUE}, \code{alpha} is updated using a scaled beta prime prior.}

\item{update_beta}{If \code{TRUE}, \code{beta} is updated using a normal prior with mean 0 and variance 4.}

\item{update_gamma}{If \code{TRUE}, gamma is updated using a Uniform(0.5, 1) prior.}

\item{update_tau}{If \code{TRUE}, the bandwidth \code{tau} is updated for each tree}

\item{update_tau_mean}{If \code{TRUE}, the mean of \code{tau} is updated}

\item{update_sigma}{If \code{TRUE}, \code{sigma} is updated, with a half-Cauchy prior on \code{sigma} centered at the initial guess.}

\item{cache_trees}{If \code{TRUE}, we save the trees for each MCMC iteration when using the MakeForest interface}
}
\value{
Returns a list containing the function arguments.
}
\description{
Creates a list that provides the parameters for running the Markov chain.
}
