% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothT.R
\name{simulation}
\alias{simulation}
\title{Generate a symmetric tensor observation from the smooth signal tensor, Gaussian noise tensor, and permutation.}
\usage{
simulation(d, mode = 1, sigma = 0.5, signal_level=5)
}
\arguments{
\item{d}{Dimension of a tensor to be generated.}

\item{mode}{An integer from 1 to 5 corresponding to models specified. Default model is 1.}

\item{sigma}{Standard deviation of the Gaussian noise tensor. Default value is 0.5.}

\item{signal_level}{A scale of the magnitude of the signal tensor to be generated.}
}
\value{
The returned object is a list of components.

\code{signal} - A true signal tensor generated from a function specified.

\code{observe} - A noisy observation  generated from the smooth signal tensor, Gaussian noise tensor, and permutation.

\code{permutation} - A true permutation.
}
\description{
Generate a symmetric tensor observation from the smooth signal tensor, Gaussian noise tensor, and permutation. Users can select one of 5 different smooth signal tensors generated from functions specified in Table 4 of the reference given below.
}
\examples{
d = 20
# Generate 20 by 20 by 20 observed tesnor generated from model 1
sim1 = simulation(d,mode = 1)
observed_tensor = sim1$observe
signal_tensor = sim1$signal
permutation = sim1$permutation
}
\references{
C. Lee and M. Wang. Smooth tensor estimation with unknown permutations. arXiv:2111.04681, 2021.
}
