% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list2df.R
\name{list2df}
\alias{list2df}
\title{Convert a list to a data frame}
\usage{
list2df(vList, col.names = NULL, row.names = NULL, convert.numeric = TRUE,
  strings.as.factors = FALSE)
}
\arguments{
\item{vList}{List of vectors, data frames, or lists. See Details.}

\item{col.names}{Optional character vector of length \code{n} with column
names that will be given to the output data frame.  If \code{col.names =
NULL}, column names are extracted if possible from the column names (or
names) of the data frames (or vectors).}

\item{row.names}{Optional character vector with length equivalent to the
length of \code{vList} containing the row names of the output data frame.
If \code{row.names = NULL}, row names from the data frames (or names of the
\code{vList} elements) if possible.}

\item{convert.numeric}{If \code{vList} is list of vectors, \code{= TRUE}
attempts to convert each column to numeric if possible using
\code{\link{as.numericSilent}}}

\item{strings.as.factors}{If \code{vList} is a list of vectors or lists, \code{=
FALSE} converts factors into characters using \code{\link{factor2character}}.}
}
\value{
If \code{vList} is list of data frames, a data frame resulting from
efficiently row binding the data frames in \code{vList} is returned.  If
\code{vList} is a list of vectors, a data frame is returned where the first
column contains the first elements of the list vectors, the second column
contains the second elements of the list vectors, etc.
}
\description{
Convert a list of vectors (or data frames) with same numbered lengths (or
number of columns) into a data frame.
}
\details{
If the elements of \code{vList} are vectors, each vector must have the same
length, \code{n}, and the resulting data frame will have \code{n} columns.
If the elements of \code{vList} are data frames, each data frame must have the
same structure (though they may have differing numbers of rows).
If the elements of \code{vList} are lists, each list is first converted to a data frame
via \code{\link{as.data.frame}} and the resulting data frames must have the
same structure (though they may have differing numbers of rows).

It is permissible for \code{vList} to contain \code{NULL} elements.
\code{list2df} performs numerous consistency checks to ensure that contents
of \code{vList} which are combined into the resulting data frame are
conformable, labeled consistently, of the equivalent class when necessary,
etc.
}
\examples{
# For a list of vectors
x <- c("r1c1 1", "r2c1 2", "r3c1 3", "r4c4 4")
y <- strsplit(x, "\\ ")
y
list2df(y)
list2df(y, col.names = LETTERS[1:2])

# Here's another list of vectors
z <- list(NULL, a = c(first = 10, second = 12), NULL, b = c(first = 15, second = 17))
z
list2df(z)

# For a list of data frames
z <- list(d1 = data.frame(a = 1:4, b = letters[1:4]),
          d2 = data.frame(a = 5:6, b = letters[5:6]))
z
list2df(z)

# A list of lists
z <- list(list(a = 10, b = TRUE, c = "hi"), list(a = 12, b = FALSE, c = c("there", "bye")))
z
list2df(z)

}
\author{
Landon Sego
}
