% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hpd.R
\name{hpd}
\alias{hpd}
\alias{print.hpd}
\alias{plot.hpd}
\title{Calculate the highest posterior density credible interval for a unimodal density}
\usage{
hpd(pdf, support, prob = 0.95, cdf = NULL, njobs = 1, checkUnimodal = 0)

\method{print}{hpd}(x, ...)

\method{plot}{hpd}(x, ...)
}
\arguments{
\item{pdf}{Function that takes a single numeric vector argument that returns a vector
of probability density values}

\item{support}{A numeric vector of length 2 giving the interval over which the random variable has
support (i.e. for which the pdf is positive).  For now, this must be a finite interval.
Intervals for random variables within infinite support
can still be calculated by setting the values of support to be suitably large and/or small.  See examples.}

\item{prob}{A numeric value in (0, 1] indicating the size of the desired probability for the credible
interval.}

\item{cdf}{A function that takes a single (not necessarily vector) argument and returns the cumulative probability.
If \code{NULL}, the pdf is integrated as needed to calculate probabilities
as needed.  However, providing the \code{cdf} will speed up calculations.}

\item{njobs}{The number of parallel jobs to spawn (where possible) using \code{\link{doCallParallel}}.  This is helpful if \code{pdf} is
expensive.}

\item{checkUnimodal}{An integer that, when greater than 0, indicates the number of points in \code{support} for which \code{pdf} is
evaluated to determine whether the function appears unimodal. This is done in parallel if \code{njobs > 1}.
If \code{checkUnimodal} is not 0, it should be a large number (like 1000 or more).}

\item{x}{object of class \code{hpd}, returned by \code{hpd}}

\item{\dots}{For the \code{plot} method, these are additional arguments that may be passed to
\code{\link{plotFun}}, \code{\link{plot.default}}, or \code{\link{abline}}}
}
\value{
A list of class \code{hpd} that contains the following elements:
\describe{
\item{lower}{The lower endpoint of the highest posterior density interval}
\item{upper}{The lower endpoint of the highest posterior density interval}
\item{prob}{The acheived probability of the interval}
\item{cut}{The horizontal cut point that gave rise to the interval}
\item{mode}{The mode of the density}
\item{pdf}{The probability density function}
\item{support}{The support of the pdf}
}
}
\description{
Calculate the highest posterior density credible interval for a unimodal density
}
\details{
Parallel processing (via \code{njobs > 1}) may be advantageous if 1) \code{pdf} is a function that is computationally expensive, 2)
the \code{cdf} is not provided, in which case \code{pdf} is integrated, and/or 3) when \code{checkUnimodal} is large.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print}: Prints the lower and upper limits of the credible interval, along with the achieved
probabilty of that interval.

\item \code{plot}: Plots the density, overlaying the lower and upper limits of the credible interval
}}

\examples{
\donttest{
# A credible interval using the standard normal
int <- hpd(dnorm, c(-5,5), prob = 0.90, njobs = 2)
print(int)
plot(int)
}

# A credible interval with the gamma density
int <- hpd(function(x) dgamma(x, shape = 2, rate = 0.5), c(0, 20),
           cdf = function(x) pgamma(x, shape = 2, rate = 0.5), prob = 0.8)
print(int)
plot(int)

\donttest{
# A credible interval using the Beta density
dens <- function(x) dbeta(x, 7, 12)
dist <- function(x) pbeta(x, 7, 12)
int <- hpd(dens, c(0, 1), cdf = dist)
print(int)
plot(int)
}
}
\author{
Landon Sego
}
