% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sizeestima.R
\name{sizeestima}
\alias{sizeestima}
\title{Estimating the sizes of populations who inject drugs
from multiple data sources using a Bayesian hierarchical model.}
\usage{
sizeestima(DATA, size, keepa, interv)
}
\arguments{
\item{DATA}{dataset from Bangladesh which used in Bao L, Raftery A, Reddy A. (2015) Estimating the Sizez of Populations At Risk of HIV Infection From Multiple Data Sources Using a Bayesian Hierarchical Model, Statistics and Its Interface.}

\item{size}{the number of iteration in MCMC algorithm.}

\item{keepa}{the number of Burn-In in MCMC algorithm.}

\item{interv}{keep every interv-th scan.}
}
\value{
A vector of the number of estimate people who inject drugs in Bangladesh. And 95 percent Bayesian confidence interval for the national number of people who inject drugs.
}
\description{
This R package is for reproducing Bao L, Raftery A, Reddy A. (2015) Estimating the Sizez of Populations At Risk of HIV Infection From Multiple Data Sources Using a Bayesian Hierarchical Model, Stat Inference. This function develops an algorithm for presenting a Bayesian hierarchical
model for estimating the sizes of national drug injected
populations in Bangladesh. The model incorporates multiple commonly used data sources
including mapping data, surveys, interventions, capture-recapture data,
estimates or guesstimates from organizations, and expert opinion. This function not only gives you total number of people who inject drugs but also 95 Bayesian confidence interval.
}
\details{
This function runs MCMC algorithm for reproducing Bao L, Raftery A, Reddy A. (2015) Estimating the Sizez of Populations At Risk of HIV Infection From Multiple Data Sources Using a Bayesian Hierarchical Model, Statistics and Its Interface.
}
\examples{
#n.total=sizeestima(DATA,5000000,501,100)
}
\author{
Le Bao, Kyongwon Kim
}
\references{
Bao L, Raftery A, Reddy A. Estimating the Sizez of Populations At Risk of HIV Infection From Multiple Data Sources Using a Bayesian Hierarchical Model, Stat Inference, 2015.
}
\seealso{
\code{\link{rtnorm} \link{rinvgamma} \link{dtnorm}}
}

